/*
 * Decompiled with CFR 0.152.
 */
package cavern.item;

import cavern.capability.CapabilityOreCompass;
import cavern.core.Cavern;
import cavern.item.OreCompass;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemOreCompass
extends Item {
    @SideOnly(value=Side.CLIENT)
    private long prevTime;

    public ItemOreCompass() {
        this.func_77655_b("compassOre");
        this.func_77625_d(1);
        this.func_77637_a(Cavern.TAB_CAVERN);
        this.func_185043_a(new ResourceLocation("angle"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase living) {
                double dir;
                OreCompass compass;
                BlockPos pos;
                EntityLivingBase entity;
                if (living == null && !stack.func_82839_y()) {
                    return 0.0f;
                }
                boolean flag = living != null;
                Object object = entity = flag ? living : stack.func_82836_z();
                if (world == null) {
                    world = entity.field_70170_p;
                }
                if ((pos = (compass = OreCompass.get(stack)).getOrePos()) != null && entity.func_174831_c(pos) < 2500.0) {
                    double d1 = flag ? (double)entity.field_70177_z : this.getFrameRotation((EntityItemFrame)entity);
                    d1 = MathHelper.func_191273_b((double)(d1 / 360.0), (double)1.0);
                    double d2 = Math.atan2((double)pos.func_177952_p() - entity.field_70161_v, (double)pos.func_177958_n() - entity.field_70165_t) / (Math.PI * 2);
                    dir = 0.5 - (d1 - 0.25 - d2);
                } else {
                    dir = Math.random();
                }
                if (flag) {
                    dir = compass.wobble(world, dir);
                }
                return MathHelper.func_188207_b((float)((float)dir), (float)1.0f);
            }

            @SideOnly(value=Side.CLIENT)
            private double getFrameRotation(EntityItemFrame entity) {
                return MathHelper.func_188209_b((int)(180 + entity.field_174860_b.func_176736_b() * 90));
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (OreCompass.get(held).refreshOrePos()) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)held);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)held);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        OreCompass.get(stack).refreshOrePos();
        return super.onEntitySwing(entityLiving, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (isSelected && entity != null && entity instanceof EntityPlayer) {
            if (this.prevTime > 0L && Minecraft.func_71386_F() - this.prevTime < 5000L) {
                return;
            }
            OreCompass.get(stack).refreshOrePos();
            this.prevTime = Minecraft.func_71386_F();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showDurabilityBar(ItemStack stack) {
        EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
        if (player == null) {
            return false;
        }
        if (player.func_184614_ca() != stack && player.func_184592_cb() != stack) {
            return false;
        }
        BlockPos pos = OreCompass.get(stack).getOrePos();
        return pos != null && !(player.func_174831_c(pos) > 2500.0);
    }

    @SideOnly(value=Side.CLIENT)
    public double getDurabilityForDisplay(ItemStack stack) {
        EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
        BlockPos pos = OreCompass.get(stack).getOrePos();
        return 1.0 - Math.sqrt(player.func_174831_c(pos)) / 50.0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xE0E0E0;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new CapabilityOreCompass();
    }
}

