/*
 * Decompiled with CFR 0.152.
 */
package cavern.item;

import cavern.capability.CaveCapabilities;
import cavern.stats.MinerStats;
import cavern.util.CaveUtils;
import javax.annotation.Nullable;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OreCompass {
    @SideOnly(value=Side.CLIENT)
    private double rotation;
    @SideOnly(value=Side.CLIENT)
    private double rota;
    @SideOnly(value=Side.CLIENT)
    private long lastUpdateTick;
    @SideOnly(value=Side.CLIENT)
    private BlockPos orePos;

    @SideOnly(value=Side.CLIENT)
    public double wobble(World world, double dir) {
        if (world.func_82737_E() != this.lastUpdateTick) {
            this.lastUpdateTick = world.func_82737_E();
            double d0 = dir - this.rotation;
            d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
            this.rota += d0 * 0.1;
            this.rota *= 0.8;
            this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.rota), (double)1.0);
        }
        return this.rotation;
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public BlockPos getOrePos() {
        return this.orePos;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean refreshOrePos() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc == null || !mc.func_71387_A()) {
            return false;
        }
        if (mc.field_71441_e == null || mc.field_71439_g == null || CaveUtils.isMoving((Entity)mc.field_71439_g)) {
            return false;
        }
        BlockPos pos = mc.field_71439_g.func_180425_c();
        ChunkCache blockAccess = MinecraftForgeClient.getRegionRenderCache((World)mc.field_71441_e, (BlockPos)pos);
        this.orePos = OreCompass.findOrePos((IBlockAccess)blockAccess, pos, 50);
        return this.orePos != null;
    }

    public static OreCompass get(ItemStack stack) {
        OreCompass compass = CaveCapabilities.getCapability((ICapabilityProvider)stack, CaveCapabilities.ORE_COMPASS);
        if (compass == null) {
            return new OreCompass();
        }
        return compass;
    }

    @Nullable
    public static BlockPos findOrePos(@Nullable IBlockAccess world, @Nullable BlockPos origin, int range) {
        if (world == null || origin == null || range <= 0) {
            return null;
        }
        int dist = 0;
        while (++dist < range) {
            BlockPos from = origin.func_177982_a(dist, 3, dist);
            BlockPos to = origin.func_177982_a(-dist, -3, -dist);
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)from, (BlockPos)to)) {
                if (world.func_175623_d(pos)) continue;
                IBlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() instanceof BlockOre || state.func_177230_c() instanceof BlockRedstoneOre) {
                    return new BlockPos((Vec3i)pos);
                }
                if (MinerStats.getPointAmount(state) <= 0) continue;
                return new BlockPos((Vec3i)pos);
            }
        }
        return null;
    }
}

