/*
 * Decompiled with CFR 0.152.
 */
package cavern.magic;

import cavern.core.CaveSounds;
import cavern.item.ItemMagicBook;
import cavern.magic.MagicBook;
import cavern.magic.MagicOverload;
import cavern.magic.SpecialMagic;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Magic {
    protected static final Random RANDOM = new Random();
    protected final World world;
    protected final EntityPlayer player;
    protected final EnumHand hand;
    protected final ItemMagicBook.EnumType magicType;
    protected final long createdTime;

    public Magic(World world, EntityPlayer player, EnumHand hand) {
        this.world = world;
        this.player = player;
        this.hand = hand;
        this.magicType = ItemMagicBook.EnumType.byItemStack(player.func_184586_b(hand));
        this.createdTime = System.currentTimeMillis();
    }

    public World getWorld() {
        return this.world;
    }

    public EntityPlayer getEntityPlayer() {
        return this.player;
    }

    public EnumHand getSpellingHand() {
        return this.hand;
    }

    public ItemStack getHeldItem() {
        return this.player.func_184586_b(this.hand);
    }

    public ItemMagicBook.EnumType getMagicType() {
        return this.magicType;
    }

    public int getMana() {
        return ItemMagicBook.getMana(this.getHeldItem());
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    @Nullable
    public SoundEvent getSpellingSound() {
        return CaveSounds.MAGIC_SPELLING;
    }

    @Nullable
    public SoundEvent getSuccessSound() {
        return CaveSounds.MAGIC_SUCCESS_MISC;
    }

    @Nullable
    public SoundEvent getCloseSound() {
        return CaveSounds.MAGIC_CLOSE_BOOK;
    }

    public abstract long getSpellTime();

    public double getSpellingProgress() {
        return MathHelper.func_151237_a((double)((double)(System.currentTimeMillis() - this.getCreatedTime()) / (double)this.getSpellTime()), (double)0.0, (double)1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumActionResult onSpelling() {
        return EnumActionResult.PASS;
    }

    public abstract ActionResult<ITextComponent> fireMagic();

    public void onCloseBook() {
    }

    public int getCost() {
        return 1;
    }

    public boolean canOverload() {
        return false;
    }

    public boolean isOverload() {
        if (!this.canOverload()) {
            return false;
        }
        SpecialMagic magic = MagicBook.get(this.player).getSpecialMagic();
        return magic != null && magic instanceof MagicOverload;
    }
}

