/*
 * Decompiled with CFR 0.152.
 */
package cavern.magic;

import cavern.api.ISummonMob;
import cavern.core.CaveSounds;
import cavern.magic.Magic;
import cavern.network.CaveNetworkRegistry;
import cavern.network.client.ExplosionMessage;
import cavern.util.PlayerHelper;
import cavern.world.CustomExplosion;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class MagicExplosion
extends Magic {
    public MagicExplosion(World world, EntityPlayer player, EnumHand hand) {
        super(world, player, hand);
    }

    @Override
    public SoundEvent getSuccessSound() {
        return CaveSounds.MAGIC_SUCCESS_STRONG;
    }

    @Override
    public long getSpellTime() {
        return 5000L;
    }

    @Override
    public ActionResult<ITextComponent> fireMagic() {
        if (!this.world.field_72995_K) {
            Vec3d hitVec = ForgeHooks.rayTraceEyeHitVec((EntityLivingBase)this.player, (double)6.0);
            if (hitVec != null) {
                this.doExplosion(new BlockPos(hitVec));
            } else {
                EnumFacing front = this.player.func_174811_aO();
                BlockPos pos = this.player.func_180425_c().func_177984_a();
                int i = 0;
                do {
                    pos = pos.func_177972_a(front);
                } while (++i < 6 && this.world.func_175623_d(pos));
                this.doExplosion(pos);
            }
            PlayerHelper.grantAdvancement(this.player, "magic_explosion");
            return new ActionResult(EnumActionResult.SUCCESS, null);
        }
        return new ActionResult(EnumActionResult.PASS, null);
    }

    @Override
    public boolean canOverload() {
        return true;
    }

    public void doExplosion(BlockPos pos) {
        boolean grief = this.world.func_82736_K().func_82766_b("mobGriefing");
        float overload = 0.0f;
        if (this.isOverload()) {
            overload = (float)this.getMana() * 0.5f;
        }
        this.createExplosion((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() + 0.5, 8.0f + overload, grief);
    }

    public Explosion createExplosion(double x, double y, double z, float strength, boolean damagesTerrain) {
        return this.newExplosion(x, y, z, strength, false, damagesTerrain, true);
    }

    public Explosion newExplosion(double x, double y, double z, float strength, boolean flaming, boolean damagesTerrain, boolean attackEntities) {
        Explosion explosion;
        if (FMLCommonHandler.instance().getSide().isServer()) {
            damagesTerrain = false;
        }
        if (ForgeEventFactory.onExplosionStart((World)this.world, (net.minecraft.world.Explosion)(explosion = new Explosion(this.world, (Entity)this.player, x, y, z, strength, flaming, damagesTerrain)))) {
            return explosion;
        }
        explosion.func_77278_a();
        explosion.func_77279_a(false);
        if (!damagesTerrain) {
            explosion.func_180342_d();
        }
        if (attackEntities) {
            explosion.doExplosionEntities();
        }
        for (EntityPlayer player : this.world.field_73010_i) {
            if (!(player instanceof EntityPlayerMP) || !(player.func_70092_e(x, y, z) < 4096.0)) continue;
            CaveNetworkRegistry.sendTo(new ExplosionMessage((float)x, (float)y, (float)z, strength, explosion.func_180343_e()), (EntityPlayerMP)player);
        }
        return explosion;
    }

    public class Explosion
    extends CustomExplosion {
        public Explosion(World world, Entity entity, double x, double y, double z, float size, boolean flaming, boolean damagesTerrain) {
            super(world, entity, x, y, z, size, flaming, damagesTerrain);
        }

        @Override
        public boolean canExplodeEntity(Entity entity) {
            if (!super.canExplodeEntity(entity)) {
                return false;
            }
            if (entity instanceof EntityItem) {
                return false;
            }
            if (entity instanceof EntityPlayer) {
                return false;
            }
            if (entity instanceof ISummonMob) {
                return false;
            }
            return !(entity instanceof IEntityOwnable) || ((IEntityOwnable)entity).func_70902_q() == null;
        }

        @Override
        protected int getExplosionAttackDamage(Entity entity, int damage) {
            entity.field_70172_ad = 0;
            if (entity.func_70027_ad()) {
                return MathHelper.func_76123_f((float)((float)damage * 2.0f));
            }
            if (!entity.field_70122_E || entity.field_70160_al) {
                return MathHelper.func_76123_f((float)((float)damage * 1.75f));
            }
            if (entity instanceof IMob) {
                return MathHelper.func_76123_f((float)((float)damage * 1.45f));
            }
            return damage;
        }
    }
}

