/*
 * Decompiled with CFR 0.152.
 */
package cavern.magic;

import cavern.item.ItemMagicBook;
import cavern.magic.Magic;
import cavern.network.CaveNetworkRegistry;
import cavern.network.server.MagicInvisibleMessage;
import cavern.util.PlayerHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MagicInvisible
extends Magic {
    private boolean invisible;

    public MagicInvisible(World world, EntityPlayer player, EnumHand hand) {
        super(world, player, hand);
    }

    @Override
    public long getSpellTime() {
        return 10000L;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumActionResult onSpelling() {
        if (!this.invisible && this.getSpellingProgress() >= 0.15) {
            CaveNetworkRegistry.sendToServer(new MagicInvisibleMessage());
            this.invisible = true;
        }
        return EnumActionResult.PASS;
    }

    @Override
    public ActionResult<ITextComponent> fireMagic() {
        return new ActionResult(EnumActionResult.FAIL, null);
    }

    @Override
    public void onCloseBook() {
        if (!this.world.field_72995_K && this.player.func_82150_aj()) {
            this.player.func_82142_c(false);
            ItemStack stack = this.getHeldItem();
            if (ItemMagicBook.consumeMana(stack, this.getCost()) > 0) {
                ItemMagicBook.setLastUseTime(stack, this.world.func_82737_E());
            } else {
                this.player.func_184611_a(this.getSpellingHand(), new ItemStack(Items.field_151122_aG));
            }
            PlayerHelper.grantAdvancement(this.player, "magic_invisible");
        }
    }
}

