/*
 * Decompiled with CFR 0.152.
 */
package cavern.magic;

import cavern.magic.Magic;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class MagicTeleport
extends Magic {
    private int teleportDistance;

    public MagicTeleport(World world, EntityPlayer player, EnumHand hand) {
        super(world, player, hand);
    }

    @Override
    public long getSpellTime() {
        return 5000L;
    }

    @Override
    public ActionResult<ITextComponent> fireMagic() {
        if (!this.world.field_72995_K) {
            int amount;
            int mana = this.getMana();
            int n = amount = mana >= 5 ? 30 : mana * 4;
            if (this.isOverload()) {
                amount += mana;
            }
            this.teleportDistance = this.teleportToFront(amount);
            return new ActionResult(this.teleportDistance > 0 ? EnumActionResult.SUCCESS : EnumActionResult.FAIL, null);
        }
        return new ActionResult(EnumActionResult.PASS, null);
    }

    public int teleportToFront(int amount) {
        int distance;
        EnumFacing front = this.player.func_174811_aO();
        BlockPos origin = this.player.func_180425_c();
        BlockPos pos = null;
        for (distance = amount; distance > 0; --distance) {
            BlockPos prev = pos = origin.func_177967_a(front, distance);
            int count = 0;
            while (!this.world.func_175623_d(pos) && ++count <= 3) {
                pos = pos.func_177984_a();
            }
            if (count > 4) {
                pos = prev;
            }
            prev = pos;
            count = 0;
            while (this.world.func_175623_d(pos.func_177977_b()) && ++count <= 3) {
                pos = pos.func_177977_b();
            }
            if (count > 4) {
                pos = prev;
            }
            if (this.world.func_175623_d(pos)) break;
        }
        if (distance <= 0 || pos == null) {
            return 0;
        }
        this.player.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        return distance;
    }

    @Override
    public int getCost() {
        return MathHelper.func_76125_a((int)(this.teleportDistance / 4), (int)1, (int)5);
    }

    @Override
    public boolean canOverload() {
        return true;
    }
}

