/*
 * Decompiled with CFR 0.152.
 */
package cavern.magic;

import cavern.api.ISummonMob;
import cavern.magic.Magic;
import cavern.util.PlayerHelper;
import com.google.common.base.Predicate;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class MagicThunderbolt
extends Magic
implements Predicate<Entity> {
    private int targetCount;

    public MagicThunderbolt(World world, EntityPlayer player, EnumHand hand) {
        super(world, player, hand);
    }

    @Override
    public long getSpellTime() {
        return 5000L;
    }

    @Override
    public ActionResult<ITextComponent> fireMagic() {
        if (!this.world.field_72995_K) {
            if (this.isOverload()) {
                int mana = this.getMana();
                BlockPos pos = this.player.func_180425_c().func_177984_a();
                int count = 0;
                while (count < 5) {
                    BlockPos blockpos = pos.func_177982_a(RANDOM.nextInt(12) - 6, 0, RANDOM.nextInt(12) - 6);
                    if (!this.world.func_175623_d(blockpos)) continue;
                    while (this.world.func_175623_d(blockpos) && blockpos.func_177956_o() > 0) {
                        blockpos = blockpos.func_177977_b();
                    }
                    this.spawnThunderbolt((double)blockpos.func_177958_n() + 0.5, blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5, false);
                    ++count;
                }
                if (mana >= 10) {
                    for (Entity entity : this.world.func_175674_a((Entity)this.player, this.player.func_174813_aQ().func_186662_g(10.0), (Predicate)this)) {
                        if (++this.targetCount <= mana / 3) {
                            this.spawnThunderbolt(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, true);
                            continue;
                        }
                        break;
                    }
                }
            } else {
                EnumFacing front = this.player.func_174811_aO();
                BlockPos pos = this.player.func_180425_c().func_177984_a();
                int i = 0;
                do {
                    pos = pos.func_177972_a(front);
                } while (++i < 8 && this.world.func_175623_d(pos));
                pos = pos.func_177972_a(front.func_176734_d());
                while (this.world.func_175623_d(pos) && pos.func_177956_o() > 0) {
                    pos = pos.func_177977_b();
                }
                int range = Math.max(5, i);
                for (Entity entity : this.world.func_175674_a((Entity)this.player, new AxisAlignedBB(pos.func_177982_a(-range, -range, -range), pos.func_177982_a(range, range, range)), (Predicate)this)) {
                    if (++this.targetCount > 3) break;
                    this.spawnThunderbolt(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, true);
                }
                if (this.targetCount <= 0) {
                    this.spawnThunderbolt((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, false);
                }
            }
            PlayerHelper.grantAdvancement(this.player, "magic_thunderbolt");
            return new ActionResult(EnumActionResult.SUCCESS, null);
        }
        return new ActionResult(EnumActionResult.PASS, null);
    }

    @Override
    public boolean canOverload() {
        return true;
    }

    public boolean apply(Entity entity) {
        if (this.player == entity || this.player.func_70028_i(entity)) {
            return false;
        }
        if (!(entity instanceof IMob) || entity instanceof ISummonMob) {
            return false;
        }
        if (entity instanceof IEntityOwnable && ((IEntityOwnable)entity).func_70902_q() != null) {
            return false;
        }
        return this.player.func_70685_l(entity);
    }

    public boolean spawnThunderbolt(double x, double y, double z, boolean targetStriker) {
        EntityThunderbolt thunderbolt = new EntityThunderbolt(this.world, x, y, z, targetStriker);
        return this.world.func_72942_c((Entity)thunderbolt);
    }

    public class EntityThunderbolt
    extends EntityLightningBolt {
        protected int field_70262_b;
        protected long field_70264_a;
        protected int field_70263_c;
        public final boolean targetStriker;

        public EntityThunderbolt(World world, double x, double y, double z, boolean targetStriker) {
            super(world, x, y, z, targetStriker);
            this.func_70012_b(x, y, z, 0.0f, 0.0f);
            this.field_70262_b = 2;
            this.field_70264_a = this.field_70146_Z.nextLong();
            this.field_70263_c = this.field_70146_Z.nextInt(3) + 1;
            this.targetStriker = targetStriker;
            BlockPos pos = new BlockPos((Entity)this);
            if (!targetStriker && !world.field_72995_K && world.func_82736_K().func_82766_b("doFireTick") && (world.func_175659_aa() == EnumDifficulty.NORMAL || world.func_175659_aa() == EnumDifficulty.HARD) && world.func_175697_a(pos, 10)) {
                if (world.func_180495_p(pos).func_185904_a() == Material.field_151579_a && Blocks.field_150480_ab.func_176196_c(world, pos)) {
                    world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                }
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.func_177982_a(this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1);
                    if (world.func_180495_p(blockpos).func_185904_a() != Material.field_151579_a || !Blocks.field_150480_ab.func_176196_c(world, blockpos)) continue;
                    world.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
                }
            }
        }

        public SoundCategory func_184176_by() {
            return SoundCategory.WEATHER;
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.field_70262_b == 2) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187754_de, SoundCategory.WEATHER, 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187752_dd, SoundCategory.WEATHER, 2.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.2f);
            }
            --this.field_70262_b;
            if (this.field_70262_b < 0) {
                if (this.field_70263_c == 0) {
                    this.func_70106_y();
                } else if (this.field_70262_b < -this.field_70146_Z.nextInt(10)) {
                    --this.field_70263_c;
                    this.field_70262_b = 1;
                    if (!this.targetStriker && !this.field_70170_p.field_72995_K) {
                        this.field_70264_a = this.field_70146_Z.nextLong();
                        BlockPos pos = new BlockPos((Entity)this);
                        if (this.field_70170_p.func_82736_K().func_82766_b("doFireTick") && this.field_70170_p.func_175697_a(pos, 10) && this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151579_a && Blocks.field_150480_ab.func_176196_c(this.field_70170_p, pos)) {
                            this.field_70170_p.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                        }
                    }
                }
            }
            if (this.field_70262_b >= 0) {
                if (this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_175702_c(2);
                } else if (this.targetStriker) {
                    for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, new AxisAlignedBB(this.field_70165_t - 3.0, this.field_70163_u - 3.0, this.field_70161_v - 3.0, this.field_70165_t + 3.0, this.field_70163_u + 6.0 + 3.0, this.field_70161_v + 3.0), (Predicate)MagicThunderbolt.this)) {
                        if (ForgeEventFactory.onEntityStruckByLightning((Entity)entity, (EntityLightningBolt)this)) continue;
                        entity.func_70097_a(DamageSource.field_180137_b, 6.0f);
                        entity.func_70015_d(15);
                        if (!(entity instanceof EntityLivingBase)) continue;
                        ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 400, this.field_70146_Z.nextInt(2) + 1, false, false));
                    }
                }
            }
        }
    }
}

