/*
 * Decompiled with CFR 0.152.
 */
package cavern.magic;

import cavern.entity.EntityMagicTorcher;
import cavern.magic.Magic;
import cavern.util.PlayerHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class MagicTorch
extends Magic {
    public MagicTorch(World world, EntityPlayer player, EnumHand hand) {
        super(world, player, hand);
    }

    @Override
    public long getSpellTime() {
        return 10000L;
    }

    @Override
    public ActionResult<ITextComponent> fireMagic() {
        if (this.world.field_72995_K) {
            if (this.player.func_70090_H() || this.player.func_180799_ab()) {
                return new ActionResult(EnumActionResult.FAIL, (Object)new TextComponentTranslation("item.magicBook.fail.place", new Object[0]));
            }
            if (!this.player.field_71071_by.func_70431_c(new ItemStack(Blocks.field_150478_aa))) {
                return new ActionResult(EnumActionResult.FAIL, (Object)new TextComponentTranslation("item.magicBook.torch.none", new Object[0]));
            }
            return new ActionResult(EnumActionResult.PASS, null);
        }
        boolean tracking = !this.player.func_70093_af();
        double range = tracking ? 6.0 : 12.0;
        for (EntityMagicTorcher torcher : this.world.func_175647_a(EntityMagicTorcher.class, this.player.func_174813_aQ().func_72321_a(range, 5.0, range), EntitySelectors.field_94557_a)) {
            EntityPlayer entityPlayer = torcher.getPlayer();
            if (entityPlayer == null || !entityPlayer.func_189512_bd().equals(this.player.func_189512_bd())) continue;
            return new ActionResult(EnumActionResult.FAIL, (Object)new TextComponentTranslation("item.magicBook.torch.exist", new Object[0]));
        }
        EntityMagicTorcher torcher = new EntityMagicTorcher(this.world, this.player, MathHelper.func_76143_f((double)range));
        torcher.setLifeTime((tracking ? 120 : 60) * 20);
        torcher.setTracking(tracking);
        this.world.func_72838_d((Entity)torcher);
        PlayerHelper.grantAdvancement(this.player, "magic_torch");
        return new ActionResult(EnumActionResult.SUCCESS, null);
    }
}

