/*
 * Decompiled with CFR 0.152.
 */
package cavern.magic;

import cavern.magic.Magic;
import cavern.util.PlayerHelper;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class MagicWarp
extends Magic {
    private double distance;
    private boolean warp;

    public MagicWarp(World world, EntityPlayer player, EnumHand hand) {
        super(world, player, hand);
    }

    @Override
    public long getSpellTime() {
        return MagicWarp.hasWarpPoint(this.getHeldItem()) ? 10000L : 5000L;
    }

    @Override
    public ActionResult<ITextComponent> fireMagic() {
        if (!this.world.field_72995_K) {
            ItemStack stack = this.getHeldItem();
            DimensionType type = this.world.field_73011_w.func_186058_p();
            Pair<BlockPos, DimensionType> warpPoint = MagicWarp.getWarpPoint(stack);
            if (warpPoint == null) {
                MagicWarp.setWarpPoint(stack, this.player.func_180425_c(), type);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)new TextComponentTranslation("item.magicBook.warp.set", new Object[0]));
            }
            BlockPos pos = (BlockPos)warpPoint.getLeft();
            if (type != warpPoint.getRight()) {
                return new ActionResult(EnumActionResult.FAIL, (Object)new TextComponentTranslation("item.magicBook.warp.far", new Object[0]));
            }
            this.distance = Math.sqrt(this.player.func_174831_c(pos));
            int mana = this.getMana();
            if (mana < 5 && this.distance > 100.0 * (double)mana) {
                return new ActionResult(EnumActionResult.FAIL, (Object)new TextComponentTranslation("item.magicBook.warp.far", new Object[0]));
            }
            if (!this.player.func_184595_k((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5)) {
                return new ActionResult(EnumActionResult.FAIL, null);
            }
            this.warp = true;
            MagicWarp.setWarpPoint(stack, null, type);
            PlayerHelper.grantAdvancement(this.player, "magic_warp");
            return new ActionResult(EnumActionResult.SUCCESS, null);
        }
        return new ActionResult(EnumActionResult.PASS, null);
    }

    @Override
    public int getCost() {
        return this.warp ? MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)(this.distance * 0.01)) + 1), (int)1, (int)5) : 1;
    }

    public static boolean hasWarpPoint(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt != null && nbt.func_150297_b("WarpPoint", 10);
    }

    @Nullable
    public static Pair<BlockPos, DimensionType> getWarpPoint(ItemStack stack) {
        DimensionType type;
        if (!MagicWarp.hasWarpPoint(stack)) {
            return null;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        NBTTagCompound compound = nbt.func_74775_l("WarpPoint");
        BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)compound);
        try {
            type = DimensionType.func_186069_a((int)compound.func_74762_e("Dim"));
        }
        catch (IllegalArgumentException e) {
            nbt.func_82580_o("WarpPoint");
            return null;
        }
        return Pair.of((Object)pos, (Object)type);
    }

    public static void setWarpPoint(ItemStack stack, @Nullable BlockPos pos, DimensionType type) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if (pos == null) {
            nbt.func_82580_o("WarpPoint");
        } else {
            NBTTagCompound compound = NBTUtil.func_186859_a((BlockPos)pos);
            compound.func_74768_a("Dim", type.func_186068_a());
            nbt.func_74782_a("WarpPoint", (NBTBase)compound);
        }
        stack.func_77982_d(nbt);
    }
}

