/*
 * Decompiled with CFR 0.152.
 */
package cavern.magic;

import cavern.core.CaveSounds;
import cavern.magic.Magic;
import cavern.magic.MagicBook;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public abstract class SpecialMagic
extends Magic {
    private long spelledTime;

    public SpecialMagic(World world, EntityPlayer player, EnumHand hand) {
        super(world, player, hand);
    }

    public long getSpelledTime() {
        return this.spelledTime;
    }

    @Override
    public SoundEvent getSuccessSound() {
        return CaveSounds.MAGIC_BREAK;
    }

    @Nullable
    public SoundEvent getFinishSound() {
        return CaveSounds.MAGIC_REVERSE;
    }

    @Override
    public abstract long getSpellTime();

    public abstract long getEffectTime();

    public double getEffectProgress() {
        return MathHelper.func_151237_a((double)((double)(System.currentTimeMillis() - this.getSpelledTime()) / (double)this.getEffectTime()), (double)0.0, (double)1.0);
    }

    @Override
    public ActionResult<ITextComponent> fireMagic() {
        MagicBook.get(this.player).setSpecialMagic(this);
        this.spelledTime = System.currentTimeMillis();
        return new ActionResult(this.world.field_72995_K ? EnumActionResult.PASS : EnumActionResult.SUCCESS, null);
    }

    @Nullable
    public ITextComponent finishMagic() {
        if (this.world.field_72995_K) {
            return new TextComponentTranslation("item.magicBook.finish", new Object[]{new TextComponentTranslation("item.magicBook." + this.getMagicType().getTranslationKey() + ".name", new Object[0])});
        }
        return null;
    }

    public boolean hasSpecialCost(Magic magic) {
        return false;
    }

    public int getSpecialCost(Magic magic) {
        return magic.getCost();
    }
}

