/*
 * Decompiled with CFR 0.152.
 */
package cavern.miningassist;

import cavern.config.MiningAssistConfig;
import cavern.miningassist.MiningSnapshot;
import cavern.util.CaveUtils;
import com.google.common.collect.Sets;
import java.util.Comparator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class QuickMiningSnapshot
extends MiningSnapshot {
    private static final int[][] CHECK_OFFSETS = new int[][]{{1, 0, 0}, {0, 1, 0}, {0, 0, 1}, {-1, 0, 0}, {0, -1, 0}, {0, 0, -1}};
    private BlockPos checkPos;

    public QuickMiningSnapshot(World world, BlockPos pos, IBlockState state) {
        super(world, pos, state);
    }

    public QuickMiningSnapshot(World world, BlockPos pos, IBlockState state, EntityLivingBase entity) {
        super(world, pos, state, entity);
    }

    @Override
    public void checkForMining() {
        this.checkPos = this.originPos;
        this.miningTargets = Sets.newTreeSet((Comparator)this);
        this.checkChain();
        super.checkForMining();
    }

    protected void checkChain() {
        boolean flag;
        do {
            flag = false;
            BlockPos pos = this.checkPos;
            for (int[] offset : CHECK_OFFSETS) {
                if (!this.offer(pos.func_177982_a(offset[0], offset[1], offset[2]))) continue;
                this.checkChain();
                if (flag) continue;
                flag = true;
            }
        } while (flag);
    }

    @Override
    public boolean offer(BlockPos pos) {
        if (MathHelper.func_76128_c((double)Math.sqrt(this.originPos.func_177951_i((Vec3i)pos))) >= MiningAssistConfig.quickMiningLimit) {
            return false;
        }
        if (super.offer(pos)) {
            this.checkPos = pos;
            return true;
        }
        return false;
    }

    @Override
    public boolean validTarget(BlockPos pos) {
        IBlockState state = this.world.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)this.world, pos) || state.func_185887_b(this.world, pos) < 0.0f) {
            return false;
        }
        return this.isRedstoneOre(state) && this.isRedstoneOre(this.originState) || CaveUtils.areBlockStatesEqual(state, this.originState);
    }

    private boolean isRedstoneOre(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150450_ax || state.func_177230_c() == Blocks.field_150439_ay;
    }
}

