/*
 * Decompiled with CFR 0.152.
 */
package cavern.miningassist;

import cavern.config.MiningAssistConfig;
import cavern.config.property.ConfigBlocks;
import cavern.miningassist.MiningAssist;
import cavern.miningassist.MiningSnapshot;
import com.google.common.collect.Sets;
import java.util.Comparator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RangedMiningSnapshot
extends MiningSnapshot {
    public RangedMiningSnapshot(World world, BlockPos pos, IBlockState state) {
        super(world, pos, state);
    }

    public RangedMiningSnapshot(World world, BlockPos pos, IBlockState state, EntityLivingBase entity) {
        super(world, pos, state, entity);
    }

    public int getRowRange() {
        return MiningAssistConfig.rangedMining;
    }

    public int getColumnRange() {
        return MiningAssistConfig.rangedMining;
    }

    @Override
    public ConfigBlocks getValidTargetBlocks() {
        return MiningAssist.RANGED.getValidTargetBlocks();
    }

    @Override
    public void checkForMining() {
        this.miningTargets = Sets.newTreeSet((Comparator)this);
        switch (EnumFacing.func_190914_a((BlockPos)this.originPos, (EntityLivingBase)this.miner).func_176740_k()) {
            case X: {
                this.checkX();
                break;
            }
            case Y: {
                this.checkY();
                break;
            }
            case Z: {
                this.checkZ();
            }
        }
        super.checkForMining();
    }

    protected void checkX() {
        int row = this.getRowRange();
        int column = this.getColumnRange();
        for (int i = -row; i <= row; ++i) {
            for (int j = -column; j <= column; ++j) {
                this.offer(this.originPos.func_177982_a(0, j, i));
            }
        }
    }

    protected void checkY() {
        int row = this.getRowRange();
        int column = this.getColumnRange();
        for (int i = -row; i <= row; ++i) {
            for (int j = -column; j <= column; ++j) {
                this.offer(this.originPos.func_177982_a(i, 0, j));
            }
        }
    }

    protected void checkZ() {
        int row = this.getRowRange();
        int column = this.getColumnRange();
        for (int i = -row; i <= row; ++i) {
            for (int j = -column; j <= column; ++j) {
                this.offer(this.originPos.func_177982_a(i, j, 0));
            }
        }
    }
}

