/*
 * Decompiled with CFR 0.152.
 */
package cavern.network.client;

import cavern.client.ClientExplosion;
import cavern.network.client.IClientMessage;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ExplosionMessage
implements IClientMessage<ExplosionMessage, IMessage> {
    private float x;
    private float y;
    private float z;
    private float strength;
    private List<BlockPos> affectedBlockPositions;

    public ExplosionMessage() {
    }

    public ExplosionMessage(float x, float y, float z, float strength, List<BlockPos> positions) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.strength = strength;
        this.affectedBlockPositions = positions;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.x = buf.readFloat();
        this.y = buf.readFloat();
        this.z = buf.readFloat();
        this.strength = buf.readFloat();
        int count = buf.readInt();
        this.affectedBlockPositions = Lists.newArrayListWithCapacity((int)count);
        int px = (int)this.x;
        int py = (int)this.y;
        int pz = (int)this.z;
        for (int i = 0; i < count; ++i) {
            int posX = buf.readByte() + px;
            int posY = buf.readByte() + py;
            int posZ = buf.readByte() + pz;
            this.affectedBlockPositions.add(new BlockPos(posX, posY, posZ));
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeFloat(this.x);
        buf.writeFloat(this.y);
        buf.writeFloat(this.z);
        buf.writeFloat(this.strength);
        buf.writeInt(this.affectedBlockPositions.size());
        int px = (int)this.x;
        int py = (int)this.y;
        int pz = (int)this.z;
        for (BlockPos pos : this.affectedBlockPositions) {
            buf.writeByte(pos.func_177958_n() - px);
            buf.writeByte(pos.func_177956_o() - py);
            buf.writeByte(pos.func_177952_p() - pz);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IMessage process(Minecraft mc) {
        new ClientExplosion(mc, this.x, this.y, this.z, this.strength, this.affectedBlockPositions).doExplosion();
        return null;
    }
}

