/*
 * Decompiled with CFR 0.152.
 */
package cavern.network.client;

import cavern.api.IMinerStats;
import cavern.network.client.IPlayerMessage;
import cavern.stats.MinerStats;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MinerDataMessage
implements IPlayerMessage<MinerDataMessage, IMessage> {
    private int point;
    private int rank;
    private int miningAssist;

    public MinerDataMessage() {
    }

    public MinerDataMessage(IMinerStats stats) {
        this.point = stats.getPoint();
        this.rank = stats.getRank();
        this.miningAssist = stats.getMiningAssist();
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.point = buf.readInt();
        this.rank = buf.readInt();
        this.miningAssist = buf.readInt();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.point);
        buf.writeInt(this.rank);
        buf.writeInt(this.miningAssist);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IMessage process(EntityPlayerSP player) {
        IMinerStats stats = MinerStats.get((EntityPlayer)player, true);
        if (stats != null) {
            stats.setPoint(this.point, false);
            stats.setRank(this.rank, false);
            stats.setMiningAssist(this.miningAssist, false);
        }
        return null;
    }
}

