/*
 * Decompiled with CFR 0.152.
 */
package cavern.network.client;

import cavern.network.client.IPlayerMessage;
import cavern.stats.MinerStats;
import cavern.stats.MiningData;
import cavern.util.BlockMeta;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.GameData;

public class MiningMessage
implements IPlayerMessage<MiningMessage, IMessage> {
    private IBlockState state;
    private int point;

    public MiningMessage() {
    }

    public MiningMessage(IBlockState state, int point) {
        this.state = state;
        this.point = point;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.state = (IBlockState)GameData.getBlockStateIDMap().func_148745_a(buf.readInt());
        this.point = buf.readInt();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(GameData.getBlockStateIDMap().func_148747_b((Object)this.state));
        buf.writeInt(this.point);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IMessage process(EntityPlayerSP player) {
        MinerStats.get((EntityPlayer)player).addMiningRecord(new BlockMeta(this.state));
        MiningData.get((EntityPlayer)player).notifyMining(this.state, this.point);
        return null;
    }
}

