/*
 * Decompiled with CFR 0.152.
 */
package cavern.network.server;

import cavern.item.ItemMagicBook;
import cavern.magic.Magic;
import cavern.magic.MagicBook;
import cavern.magic.SpecialMagic;
import cavern.network.server.IPlayerMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MagicResultMessage
implements IPlayerMessage<MagicResultMessage, IMessage> {
    private EnumActionResult clientResult;

    public MagicResultMessage() {
    }

    public MagicResultMessage(EnumActionResult clientResult) {
        this.clientResult = clientResult;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.clientResult = EnumActionResult.values()[buf.readInt()];
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.clientResult.ordinal());
    }

    @Override
    public IMessage process(EntityPlayerMP player) {
        MagicBook book = MagicBook.get((EntityPlayer)player);
        Magic magic = book.getSpellingMagic();
        if (magic != null) {
            ITextComponent message;
            EnumActionResult type;
            if (this.clientResult == EnumActionResult.PASS) {
                ActionResult<ITextComponent> result = magic.fireMagic();
                type = result.func_188397_a();
                message = (ITextComponent)result.func_188398_b();
            } else {
                type = this.clientResult;
                message = null;
            }
            if (type == EnumActionResult.SUCCESS) {
                ItemStack stack = book.getSpellingMagicBook();
                WorldServer world = player.func_71121_q();
                int cost = 0;
                SpecialMagic specialMagic = book.getSpecialMagic();
                cost = specialMagic != null && specialMagic != magic && specialMagic.hasSpecialCost(magic) ? specialMagic.getSpecialCost(magic) : magic.getCost();
                if (cost == 0) {
                    ItemMagicBook.setLastUseTime(stack, world.func_82737_E());
                } else if (ItemMagicBook.consumeMana(stack, cost) > 0) {
                    ItemMagicBook.setLastUseTime(stack, world.func_82737_E());
                } else {
                    player.func_184611_a(magic.getSpellingHand(), new ItemStack(Items.field_151122_aG));
                }
                SoundEvent sound = magic.getSuccessSound();
                if (sound != null) {
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.25, player.field_70161_v, sound, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                if (magic.isOverload()) {
                    book.setSpecialMagic(null);
                }
            }
            if (message != null) {
                player.func_146105_b(message, true);
            }
            magic.onCloseBook();
        }
        book.setSpellingMagic(null);
        return null;
    }
}

