/*
 * Decompiled with CFR 0.152.
 */
package cavern.network.server;

import cavern.network.CaveNetworkRegistry;
import cavern.network.client.RegenerationGuiMessage;
import cavern.network.server.ISimpleMessage;
import cavern.stats.PortalCache;
import cavern.util.CaveUtils;
import cavern.world.CaveDimensions;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.io.FileUtils;

public class RegenerationMessage
implements ISimpleMessage<RegenerationMessage, IMessage> {
    public boolean backup;
    public final List<DimensionType> dimensions = Lists.newArrayList();

    @Override
    public void fromBytes(ByteBuf buf) {
        this.backup = buf.readBoolean();
        int i = buf.readInt();
        if (i <= 0) {
            return;
        }
        while (i-- > 0) {
            int dim = buf.readInt();
            try {
                this.dimensions.add(DimensionType.func_186069_a((int)dim));
            }
            catch (IllegalArgumentException e) {}
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.backup);
        buf.writeInt(this.dimensions.size());
        for (DimensionType type : this.dimensions) {
            if (type == null) continue;
            buf.writeInt(type.func_186068_a());
        }
    }

    @Override
    public IMessage process() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        File rootDir = DimensionManager.getCurrentSaveRootDirectory();
        if (rootDir == null || !rootDir.exists()) {
            return new RegenerationGuiMessage(RegenerationGuiMessage.EnumType.FAILED);
        }
        server.func_184103_al().func_72389_g();
        for (DimensionType type : this.dimensions) {
            WorldServer world = DimensionManager.getWorld((int)type.func_186068_a());
            if (world != null) {
                for (EntityPlayer player : world.field_73010_i) {
                    if (player == null || !(player instanceof EntityPlayerMP)) continue;
                    EntityPlayerMP playerMP = (EntityPlayerMP)player;
                    if (playerMP.field_71135_a == null) continue;
                    playerMP.field_71135_a.func_194028_b((ITextComponent)new TextComponentTranslation("cavern.message.disconnect.unload", new Object[0]));
                }
                try {
                    world.func_73044_a(true, null);
                }
                catch (MinecraftException e) {
                    return new RegenerationGuiMessage(RegenerationGuiMessage.EnumType.FAILED);
                }
                world.func_73041_k();
                MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((World)world));
                DimensionManager.setWorld((int)world.field_73011_w.getDimension(), null, (MinecraftServer)server);
                world.func_72912_H().setDimensionData(world.field_73011_w.getDimension(), null);
            }
            for (EntityPlayer player : server.func_184103_al().func_181057_v()) {
                if (player == null) continue;
                PortalCache.get((ICapabilityProvider)player).clearLastPos(null, type);
                player.setSpawnChunk(null, false, type.func_186068_a());
            }
            File dimDir = new File(rootDir, "DIM" + type.func_186068_a());
            if (!dimDir.exists()) {
                return new RegenerationGuiMessage(RegenerationGuiMessage.EnumType.FAILED);
            }
            TextComponentString name = new TextComponentString(CaveDimensions.getLocalizedName(type));
            name.func_150256_b().func_150227_a(Boolean.valueOf(true));
            this.sendProgress(RegenerationGuiMessage.EnumType.START);
            TextComponentTranslation message = new TextComponentTranslation("cavern.regeneration.regenerating", new Object[]{name});
            message.func_150256_b().func_150238_a(TextFormatting.GRAY);
            server.func_184103_al().func_148539_a((ITextComponent)message);
            if (this.backup) {
                message = new TextComponentTranslation("cavern.regeneration.backup", new Object[]{name});
                message.func_150256_b().func_150238_a(TextFormatting.GRAY);
                server.func_184103_al().func_148539_a((ITextComponent)message);
                this.sendProgress(RegenerationGuiMessage.EnumType.BACKUP);
                Calendar calendar = Calendar.getInstance();
                String year = Integer.toString(calendar.get(1));
                String month = String.format("%02d", calendar.get(2) + 1);
                String day = String.format("%02d", calendar.get(5));
                String hour = String.format("%02d", calendar.get(11));
                String minute = String.format("%02d", calendar.get(12));
                String second = String.format("%02d", calendar.get(13));
                File bak = new File(rootDir, type.func_186065_b() + "_bak-" + String.join((CharSequence)"", year, month, day) + "-" + String.join((CharSequence)"", hour, minute, second) + ".zip");
                if (CaveUtils.archiveDirectory(dimDir, bak)) {
                    message = new TextComponentTranslation("cavern.regeneration.backup.success", new Object[]{name});
                    message.func_150256_b().func_150238_a(TextFormatting.GRAY);
                    server.func_184103_al().func_148539_a((ITextComponent)message);
                } else {
                    message = new TextComponentTranslation("cavern.regeneration.backup.failed", new Object[]{name});
                    message.func_150256_b().func_150238_a(TextFormatting.RED);
                    server.func_184103_al().func_148539_a((ITextComponent)message);
                    return new RegenerationGuiMessage(RegenerationGuiMessage.EnumType.FAILED);
                }
            }
            try {
                FileUtils.deleteDirectory((File)dimDir);
            }
            catch (IOException e) {
                return new RegenerationGuiMessage(RegenerationGuiMessage.EnumType.FAILED);
            }
            message = new TextComponentTranslation("cavern.regeneration.regenerated", new Object[]{name});
            message.func_150256_b().func_150238_a(TextFormatting.GRAY);
            server.func_184103_al().func_148539_a((ITextComponent)message);
            if (!type.shouldLoadSpawn()) continue;
            world = server.func_71218_a(type.func_186068_a());
            try {
                world.func_73044_a(true, null);
            }
            catch (MinecraftException minecraftException) {
                // empty catch block
            }
            world.func_73041_k();
        }
        return new RegenerationGuiMessage(RegenerationGuiMessage.EnumType.REGENERATED);
    }

    private void sendProgress(RegenerationGuiMessage.EnumType type) {
        CaveNetworkRegistry.sendToAll(new RegenerationGuiMessage(type));
    }
}

