/*
 * Decompiled with CFR 0.152.
 */
package cavern.plugin;

import cavern.stats.MinerRank;
import cavern.stats.MinerStats;
import cavern.util.CaveUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import shift.mceconomy3.api.MCEconomyAPI;
import shift.mceconomy3.api.shop.IProduct;
import shift.mceconomy3.api.shop.IShop;

public class MCEPortalShop
implements IShop {
    private final ArrayList<IProduct> products = Lists.newArrayList();

    public ResourceLocation getRegistryName() {
        return CaveUtils.getKey("portal_shop");
    }

    public String getShopName(World world, EntityPlayer player) {
        return "shop.cavern.portal.name";
    }

    public void addProduct(IProduct product) {
        if (product != null) {
            this.products.add(product);
        }
    }

    public ArrayList<IProduct> getProductList(World world, EntityPlayer player) {
        return this.products;
    }

    public void addProduct(ItemStack item) {
        this.addProduct(item, null);
    }

    public void addProduct(ItemStack item, int cost) {
        this.addProduct(item, cost, null);
    }

    public void addProduct(ItemStack item, @Nullable MinerRank rank) {
        int cost = MCEconomyAPI.getPurchase((ItemStack)item);
        if (cost > 0) {
            this.addProduct(item, cost * 2, rank);
        }
    }

    public void addProduct(ItemStack item, int cost, @Nullable MinerRank rank) {
        this.addProduct(new ShopProduct(item, cost, rank));
    }

    public static class ShopProduct
    implements IProduct {
        private final ItemStack productItem;
        private final int cost;
        private final MinerRank minerRank;

        public ShopProduct(ItemStack item, int cost, @Nullable MinerRank rank) {
            this.productItem = item;
            this.cost = cost;
            this.minerRank = rank;
        }

        public ItemStack getItem(IShop shop, World world, EntityPlayer player) {
            return this.productItem.func_77946_l();
        }

        public int getCost(IShop shop, World world, EntityPlayer player) {
            if (world != null && player != null) {
                BlockPos pos = player.func_180425_c();
                DifficultyInstance difficulty = world.func_175649_E(pos);
                return (int)((float)this.cost * MathHelper.func_76131_a((float)difficulty.func_180168_b(), (float)1.0f, (float)3.0f));
            }
            return this.cost;
        }

        public boolean canBuy(IShop shop, World world, EntityPlayer player) {
            return this.minerRank == null || player != null && MinerStats.get(player).getRank() >= this.minerRank.getRank();
        }
    }
}

