/*
 * Decompiled with CFR 0.152.
 */
package cavern.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.util.math.MathHelper;

public class ArrayListExtended<E>
extends ArrayList<E> {
    public ArrayListExtended() {
    }

    public ArrayListExtended(Collection<? extends E> c) {
        super(c);
    }

    public boolean addIfAbsent(E value) {
        return value != null && !this.contains(value) && this.add(value);
    }

    public boolean addObject(Object obj) {
        return obj != null && this.add(obj);
    }

    public ArrayListExtended<E> addAllObject(Collection<?> c) {
        for (Object obj : c.toArray()) {
            this.addObject(obj);
        }
        return this;
    }

    public ArrayListExtended<E> addAllObject(Iterable<?> iterable) {
        for (Object obj : iterable) {
            this.addObject(obj);
        }
        return this;
    }

    public ArrayListExtended<E> addAllObject(Object ... objects) {
        for (Object obj : objects) {
            this.addObject(obj);
        }
        return this;
    }

    public E get(int index, E value) {
        return index < 0 || index >= this.size() || this.get(index) == null ? value : this.get(index);
    }

    public ArrayListExtended<E> swap(int index1, int index2) {
        if (index1 >= 0 && index1 < this.size() && index2 >= 0 && index2 < this.size()) {
            Collections.swap(this, index1, index2);
        }
        return this;
    }

    public ArrayListExtended<E> swapTo(int index, int amount) {
        return this.swap(index, MathHelper.func_76125_a((int)(index + amount), (int)0, (int)(this.size() - 1)));
    }
}

