/*
 * Decompiled with CFR 0.152.
 */
package cavern.util;

import cavern.util.BlockMeta;
import cavern.util.ItemMeta;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class CaveFilters {
    public static boolean blockFilter(@Nullable BlockMeta blockMeta, @Nullable String filter) {
        if (blockMeta == null || Strings.isNullOrEmpty((String)filter)) {
            return false;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)blockMeta.getName(), (CharSequence)filter)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)blockMeta.getMetaString(), (CharSequence)filter)) {
            return true;
        }
        Block block = blockMeta.getBlock();
        ItemStack stack = new ItemStack(block, 1, blockMeta.getMeta());
        if (stack.func_77973_b() == Items.field_190931_a) {
            if (StringUtils.containsIgnoreCase((CharSequence)block.func_149732_F(), (CharSequence)filter)) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)block.func_149739_a(), (CharSequence)filter)) {
                return true;
            }
        } else {
            if (StringUtils.containsIgnoreCase((CharSequence)stack.func_82833_r(), (CharSequence)filter)) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)stack.func_77977_a(), (CharSequence)filter)) {
                return true;
            }
        }
        return StringUtils.containsIgnoreCase((CharSequence)block.getHarvestTool(blockMeta.getBlockState()), (CharSequence)filter);
    }

    public static boolean itemFilter(@Nullable ItemMeta itemMeta, @Nullable String filter) {
        if (itemMeta == null || Strings.isNullOrEmpty((String)filter)) {
            return false;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)itemMeta.getName(), (CharSequence)filter)) {
            return true;
        }
        ItemStack stack = itemMeta.getItemStack();
        if (StringUtils.containsIgnoreCase((CharSequence)stack.func_82833_r(), (CharSequence)filter)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)stack.func_77977_a(), (CharSequence)filter)) {
            return true;
        }
        return stack.func_77973_b().getToolClasses(stack).contains(filter);
    }

    public static boolean biomeFilter(@Nullable Biome biome, @Nullable String filter) {
        ImmutableList list;
        BiomeManager.BiomeType type;
        if (biome == null || Strings.isNullOrEmpty((String)filter)) {
            return false;
        }
        if (Biome.func_185362_a((Biome)biome) == NumberUtils.toInt((String)filter, (int)-1) || StringUtils.containsIgnoreCase((CharSequence)biome.getRegistryName().toString(), (CharSequence)filter)) {
            return true;
        }
        for (BiomeDictionary.Type type2 : BiomeDictionary.getTypes((Biome)biome)) {
            if (!type2.getName().equalsIgnoreCase(filter)) continue;
            return true;
        }
        if (CaveFilters.blockFilter(new BlockMeta(biome.field_76752_A), filter)) {
            return true;
        }
        if (CaveFilters.blockFilter(new BlockMeta(biome.field_76753_B), filter)) {
            return true;
        }
        try {
            type = BiomeManager.BiomeType.valueOf((String)filter.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            type = null;
        }
        if (type != null && (list = BiomeManager.getBiomes((BiomeManager.BiomeType)type)) != null) {
            for (BiomeManager.BiomeEntry entry : list) {
                if (entry == null || !entry.biome.getRegistryName().equals((Object)biome.getRegistryName())) continue;
                return true;
            }
        }
        return false;
    }
}

