/*
 * Decompiled with CFR 0.152.
 */
package cavern.util;

import cavern.core.Cavern;
import cavern.util.CaveLog;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class CaveUtils {
    public static ModContainer getModContainer() {
        ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get("cavern");
        if (!(mod != null || (mod = Loader.instance().activeModContainer()) != null && "cavern".equals(mod.getModId()))) {
            return new DummyModContainer(Cavern.metadata);
        }
        return mod;
    }

    public static ResourceLocation getKey(String key) {
        return new ResourceLocation("cavern", key);
    }

    public static int compareWithNull(Object o1, Object o2) {
        return (o1 == null ? 1 : 0) - (o2 == null ? 1 : 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean archiveDirectory(File dir, File dest) {
        final Path dirPath = dir.toPath();
        final String parent = dir.getName();
        HashMap env = Maps.newHashMap();
        env.put("create", "true");
        URI uri = dest.toURI();
        try {
            uri = new URI("jar:" + uri.getScheme(), uri.getPath(), null);
        }
        catch (URISyntaxException e) {
            return false;
        }
        try (final FileSystem zipfs = FileSystems.newFileSystem(uri, env);){
            Files.createDirectory(zipfs.getPath(parent, new String[0]), new FileAttribute[0]);
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.copy(file, zipfs.getPath(parent, dirPath.relativize(file).toString()), StandardCopyOption.REPLACE_EXISTING);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                            Files.createDirectory(zipfs.getPath(parent, dirPath.relativize(dir).toString()), new FileAttribute[0]);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    continue;
                }
                Files.copy(file.toPath(), zipfs.getPath(parent, file.getName()), StandardCopyOption.REPLACE_EXISTING);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            CaveLog.log(Level.WARN, e, "An error occurred archiving the " + parent + "directory.", new Object[0]);
            return false;
        }
    }

    public static boolean areBlockStatesEqual(@Nullable IBlockState stateA, @Nullable IBlockState stateB) {
        if (stateA == stateB) {
            return true;
        }
        if (stateA == null || stateB == null) {
            return false;
        }
        return stateA.func_177230_c() == stateB.func_177230_c() && stateA.func_177230_c().func_176201_c(stateA) == stateB.func_177230_c().func_176201_c(stateB);
    }

    public static boolean isItemEqual(ItemStack target, ItemStack input) {
        if (target.func_77981_g()) {
            return OreDictionary.itemMatches((ItemStack)target, (ItemStack)input, (boolean)false);
        }
        return target.func_77973_b() == input.func_77973_b();
    }

    @Nullable
    public static <E> E getRandomObject(@Nullable List<E> list) {
        return CaveUtils.getRandomObject(list, null);
    }

    public static <E> E getRandomObject(@Nullable List<E> list, @Nullable E nullDefault) {
        if (list == null || list.isEmpty()) {
            return nullDefault;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return list.get(MathHelper.func_76128_c((double)(Math.random() * (double)list.size())));
    }

    public static boolean isItemPickaxe(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemPickaxe) {
            return true;
        }
        return item.getToolClasses(stack).contains("pickaxe");
    }

    @Nullable
    public static String getEntityName(ResourceLocation key) {
        if (key == null) {
            return null;
        }
        String entityName = EntityList.func_191302_a((ResourceLocation)key);
        if (!Strings.isNullOrEmpty((String)entityName)) {
            return Cavern.proxy.translate("entity." + entityName + ".name");
        }
        return key.toString();
    }

    @Nullable
    public static String getEntityName(Class<? extends Entity> entityClass) {
        return CaveUtils.getEntityName(EntityList.func_191306_a(entityClass));
    }

    public static boolean isMoving(@Nullable Entity entity) {
        if (entity == null) {
            return false;
        }
        double motionX = entity.field_70159_w;
        double motionY = entity.field_70181_x;
        double motionZ = entity.field_70179_y;
        return motionX * motionX + motionY * motionY + motionZ * motionZ > 0.01;
    }
}

