/*
 * Decompiled with CFR 0.152.
 */
package cavern.util;

import cavern.core.Cavern;
import cavern.util.CaveUtils;
import com.google.common.base.Strings;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraftforge.classloading.FMLForgePlugin;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class Version {
    private static String CURRENT;
    public static boolean DEV_DEBUG;

    public static void initVersion() {
        File file;
        CURRENT = Strings.nullToEmpty((String)Cavern.metadata.version);
        ModContainer mod = CaveUtils.getModContainer();
        File file2 = file = mod == null ? null : mod.getSource();
        if (file != null && file.exists()) {
            if (file.isFile()) {
                String name = FilenameUtils.getBaseName((String)file.getName());
                if (StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)"dev")) {
                    DEV_DEBUG = true;
                }
            } else if (file.isDirectory()) {
                DEV_DEBUG = true;
            }
        } else if (!FMLForgePlugin.RUNTIME_DEOBF) {
            DEV_DEBUG = true;
        }
        if (Cavern.metadata.version.endsWith("dev")) {
            DEV_DEBUG = true;
        } else if (DEV_DEBUG) {
            Cavern.metadata.version = Cavern.metadata.version + "-dev";
        }
    }

    public static ForgeVersion.CheckResult getResult() {
        return ForgeVersion.getResult((ModContainer)CaveUtils.getModContainer());
    }

    public static ForgeVersion.Status getStatus() {
        return Version.getResult().status;
    }

    @Nullable
    public static ComparableVersion getTarget() {
        return Version.getResult().target;
    }

    public static String getCurrent() {
        return CURRENT;
    }

    public static ComparableVersion getLatest() {
        return (ComparableVersion)ObjectUtils.defaultIfNull((Object)Version.getTarget(), (Object)new ComparableVersion(CURRENT));
    }

    public static boolean isOutdated() {
        return Version.getStatus() == ForgeVersion.Status.OUTDATED || Version.getStatus() == ForgeVersion.Status.BETA_OUTDATED;
    }

    public static boolean isBeta() {
        return StringUtils.containsIgnoreCase((CharSequence)CURRENT, (CharSequence)"beta");
    }

    public static boolean isAlpha() {
        return StringUtils.containsIgnoreCase((CharSequence)CURRENT, (CharSequence)"alpha");
    }

    static {
        DEV_DEBUG = false;
    }
}

