/*
 * Decompiled with CFR 0.152.
 */
package cavern.world;

import cavern.config.manager.CaveBiomeManager;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;

public class BiomeProviderCavern
extends BiomeProvider {
    private final World worldObj;
    private final Random random;
    private final BiomeCache biomeCache;
    private final int biomeSize;
    private final CaveBiomeManager biomeManager;

    public BiomeProviderCavern(World world, int biomeSize, CaveBiomeManager manager) {
        this.worldObj = world;
        this.random = new Random(world.func_72905_C());
        this.biomeCache = new BiomeCache((BiomeProvider)this);
        this.biomeSize = biomeSize;
        this.biomeManager = manager;
    }

    public List<Biome> func_76932_a() {
        return Lists.newArrayList(this.biomeManager.getCaveBiomes().keySet());
    }

    private Biome getCaveBiomeGenAt(BlockPos pos) {
        int chunkX = pos.func_177958_n() >> 4;
        int chunkZ = pos.func_177952_p() >> 4;
        if (this.biomeSize <= 0) {
            this.random.setSeed(ChunkPos.func_77272_a((int)chunkX, (int)chunkZ) ^ this.worldObj.func_72905_C());
        } else {
            this.random.setSeed(ChunkPos.func_77272_a((int)((chunkX + 1) / this.biomeSize), (int)((chunkZ + 1) / this.biomeSize)) ^ this.worldObj.func_72905_C());
        }
        return this.biomeManager.getRandomBiome(this.random, Biomes.field_76772_c);
    }

    public Biome func_180631_a(BlockPos pos) {
        return this.func_180300_a(pos, Biomes.field_76772_c);
    }

    public Biome func_180300_a(BlockPos pos, Biome defaultBiome) {
        Biome biome = this.biomeCache.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), null);
        if (biome == null) {
            biome = this.getCaveBiomeGenAt(pos);
        }
        return biome == null ? defaultBiome : biome;
    }

    public Biome[] func_76937_a(Biome[] biomes, int x, int z, int xSize, int zSize) {
        if (biomes == null || biomes.length < xSize * zSize) {
            biomes = new Biome[xSize * zSize];
        }
        Arrays.fill(biomes, this.getCaveBiomeGenAt(new BlockPos(x, 0, z)));
        return biomes;
    }

    public Biome[] func_76933_b(Biome[] biomes, int x, int z, int xSize, int zSize) {
        return this.func_76937_a(biomes, x, z, xSize, zSize);
    }

    public Biome[] func_76931_a(Biome[] biomes, int x, int z, int xSize, int zSize, boolean cache) {
        return this.func_76937_a(biomes, x, z, xSize, zSize);
    }

    public boolean func_76940_a(int x, int z, int range, List<Biome> list) {
        return list.contains(this.func_180631_a(new BlockPos(x, 0, z)));
    }

    public BlockPos func_180630_a(int x, int z, int range, List<Biome> list, Random random) {
        return new BlockPos(x - range + random.nextInt(range * 2 + 1), 0, z - range + random.nextInt(range * 2 + 1));
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }
}

