/*
 * Decompiled with CFR 0.152.
 */
package cavern.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;

public class CaveEntitySpawner {
    private static final int MOB_COUNT_DIV = (int)Math.pow(17.0, 2.0);
    private final Set<ChunkPos> eligibleChunksForSpawning = Sets.newHashSet();
    private final IWorldEntitySpawner entitySpawner;

    public CaveEntitySpawner() {
        this(null);
    }

    public CaveEntitySpawner(@Nullable IWorldEntitySpawner spawner) {
        this.entitySpawner = spawner;
    }

    public int findChunksForSpawning(WorldServer world, boolean spawnHostileMobs, boolean spawnPeacefulMobs, boolean spawnOnSetTickRate) {
        if (!spawnHostileMobs && !spawnPeacefulMobs) {
            return 0;
        }
        this.eligibleChunksForSpawning.clear();
        int playerCount = 0;
        double playerHeight = 0.0;
        for (EntityPlayer player : world.field_73010_i) {
            if (player.func_175149_v()) continue;
            int j = MathHelper.func_76128_c((double)(player.field_70165_t / 16.0));
            int k = MathHelper.func_76128_c((double)(player.field_70161_v / 16.0));
            int range = 8;
            for (int i1 = -range; i1 <= range; ++i1) {
                for (int j1 = -range; j1 <= range; ++j1) {
                    PlayerChunkMapEntry entry;
                    boolean flag = i1 == -range || i1 == range || j1 == -range || j1 == range;
                    ChunkPos pos = new ChunkPos(i1 + j, j1 + k);
                    if (this.eligibleChunksForSpawning.contains(pos)) continue;
                    ++playerCount;
                    playerHeight += player.field_70163_u;
                    if (flag || !world.func_175723_af().func_177730_a(pos) || (entry = world.func_184164_w().func_187301_b(pos.field_77276_a, pos.field_77275_b)) == null || !entry.func_187274_e()) continue;
                    this.eligibleChunksForSpawning.add(pos);
                }
            }
        }
        int playerY = playerHeight > 0.0 ? MathHelper.func_76143_f((double)(playerHeight / (double)playerCount)) : 50;
        int totalCount = 0;
        BlockPos spawnPos = world.func_175694_M();
        for (EnumCreatureType type : EnumCreatureType.values()) {
            int maxNumber = this.getMaxNumberOfCreature(world, spawnHostileMobs, spawnPeacefulMobs, spawnOnSetTickRate, type);
            double range = this.getSpawnRange(world, spawnHostileMobs, spawnPeacefulMobs, spawnOnSetTickRate, type);
            if (maxNumber <= 0 || !this.canSpawnCreature(world, spawnHostileMobs, spawnPeacefulMobs, spawnOnSetTickRate, type)) continue;
            int max = maxNumber * playerCount / MOB_COUNT_DIV;
            if (world.countEntities(type, true) > max) continue;
            ArrayList shuffled = Lists.newArrayList(this.eligibleChunksForSpawning);
            Collections.shuffle(shuffled);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            block6: for (ChunkPos chunkpos : shuffled) {
                BlockPos blockpos = this.getRandomPosition((World)world, chunkpos.field_77276_a, playerY, chunkpos.field_77275_b);
                int originX = blockpos.func_177958_n();
                int originY = blockpos.func_177956_o();
                int originZ = blockpos.func_177952_p();
                IBlockState state = world.func_180495_p(blockpos);
                if (state.func_185915_l()) continue;
                int mobCount = 0;
                block7: for (int l = 0; l < 3; ++l) {
                    int x = originX;
                    int y = originY;
                    int z = originZ;
                    int n = 6;
                    Biome.SpawnListEntry entry = null;
                    IEntityLivingData data = null;
                    int f = MathHelper.func_76143_f((double)(Math.random() * 4.0));
                    for (int m = 0; m < f; ++m) {
                        EntityLiving entity;
                        pos.func_181079_c(x += world.field_73012_v.nextInt(n) - world.field_73012_v.nextInt(n), y += world.field_73012_v.nextInt(1) - world.field_73012_v.nextInt(1), z += world.field_73012_v.nextInt(n) - world.field_73012_v.nextInt(n));
                        float posX = (float)x + 0.5f;
                        float posZ = (float)z + 0.5f;
                        if (world.func_175636_b((double)posX, (double)y, (double)posZ, range) || !(spawnPos.func_177954_c((double)posX, (double)y, (double)posZ) >= range * range)) continue;
                        if (entry == null && (entry = world.func_175734_a(type, (BlockPos)pos)) == null) continue block7;
                        if (!world.func_175732_a(type, entry, (BlockPos)pos) || !WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntitySpawnPlacementRegistry.func_180109_a((Class)entry.field_76300_b), (World)world, (BlockPos)pos)) continue;
                        try {
                            entity = entry.newInstance((World)world);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return totalCount;
                        }
                        entity.func_70012_b((double)posX, (double)y, (double)posZ, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entity, (World)world, (float)posX, (float)y, (float)posZ, null);
                        if (canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT && entity.func_70601_bi() && entity.func_70058_J()) {
                            if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entity, (World)world, (float)posX, (float)y, (float)posZ, null)) {
                                data = entity.func_180482_a(world.func_175649_E(entity.func_180425_c()), data);
                            }
                            if (entity.func_70058_J()) {
                                ++mobCount;
                                world.func_72838_d((Entity)entity);
                            } else {
                                entity.func_70106_y();
                            }
                            if (mobCount >= ForgeEventFactory.getMaxSpawnPackSize((EntityLiving)entity)) continue block6;
                        }
                        totalCount += mobCount;
                    }
                }
            }
        }
        return totalCount;
    }

    protected boolean canSpawnCreature(WorldServer world, boolean spawnHostileMobs, boolean spawnPeacefulMobs, boolean spawnOnSetTickRate, EnumCreatureType type) {
        Boolean ret;
        if (this.entitySpawner != null && (ret = this.entitySpawner.canSpawnCreature(world, spawnHostileMobs, spawnPeacefulMobs, spawnOnSetTickRate, type)) != null) {
            return ret;
        }
        return !(type.func_75599_d() && !spawnPeacefulMobs || !type.func_75599_d() && !spawnHostileMobs || type.func_82705_e() && !spawnOnSetTickRate);
    }

    protected int getMaxNumberOfCreature(WorldServer world, boolean spawnHostileMobs, boolean spawnPeacefulMobs, boolean spawnOnSetTickRate, EnumCreatureType type) {
        Integer ret;
        if (this.entitySpawner != null && (ret = this.entitySpawner.getMaxNumberOfCreature(world, spawnHostileMobs, spawnPeacefulMobs, spawnOnSetTickRate, type)) != null) {
            return ret;
        }
        return type.func_75601_b();
    }

    protected double getSpawnRange(WorldServer world, boolean spawnHostileMobs, boolean spawnPeacefulMobs, boolean spawnOnSetTickRate, EnumCreatureType type) {
        Double ret;
        if (this.entitySpawner != null && (ret = this.entitySpawner.getSpawnRange(world, spawnHostileMobs, spawnPeacefulMobs, spawnOnSetTickRate, type)) != null) {
            return ret;
        }
        return 24.0;
    }

    protected BlockPos getRandomPosition(World world, int x, int y, int z) {
        int posX = x * 16 + world.field_73012_v.nextInt(16);
        int posZ = z * 16 + world.field_73012_v.nextInt(16);
        int posY = MathHelper.func_76136_a((Random)world.field_73012_v, (int)Math.max(y - 32, 1), (int)Math.min(y + 32, world.func_72940_L()));
        return new BlockPos(posX, posY, posZ);
    }

    public static interface IWorldEntitySpawner {
        @Nullable
        default public Boolean canSpawnCreature(WorldServer world, boolean spawnHostileMobs, boolean spawnPeacefulMobs, boolean spawnOnSetTickRate, EnumCreatureType type) {
            return null;
        }

        @Nullable
        public Integer getMaxNumberOfCreature(WorldServer var1, boolean var2, boolean var3, boolean var4, EnumCreatureType var5);

        @Nullable
        default public Double getSpawnRange(WorldServer world, boolean spawnHostileMobs, boolean spawnPeacefulMobs, boolean spawnOnSetTickRate, EnumCreatureType type) {
            return null;
        }
    }
}

