/*
 * Decompiled with CFR 0.152.
 */
package cavern.world;

import cavern.api.IPortalCache;
import cavern.block.BlockPortalCavern;
import cavern.stats.PortalCache;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.ITeleporter;
import org.apache.commons.lang3.ObjectUtils;

public class TeleporterCavern
implements ITeleporter {
    private static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final IBlockState MOSSY_STONE = Blocks.field_150341_Y.func_176223_P();
    protected final WorldServer world;
    protected final Random random;
    protected final BlockPortalCavern portalBlock;
    private IPortalCache teleporterCache;

    public TeleporterCavern(WorldServer world, BlockPortalCavern portal) {
        this.world = world;
        this.random = new Random(world.func_72905_C());
        this.portalBlock = portal;
    }

    protected IPortalCache getCache(ICapabilityProvider provider) {
        if (this.teleporterCache != null) {
            return this.teleporterCache;
        }
        this.teleporterCache = PortalCache.get(provider);
        return this.teleporterCache;
    }

    public void placeEntity(World worldIn, Entity entity, float yaw) {
        int baseY = this.world.func_181545_F();
        int rangeY = 30;
        int min = baseY - rangeY;
        int max = baseY + rangeY;
        int worldHeight = this.world.func_72940_L();
        max = Math.min(min < 0 ? max + Math.abs(min) : max, worldHeight);
        min = Math.max(max > worldHeight ? Math.max(min - (max - worldHeight), 0) : min, 0);
        BlockPos pos = new BlockPos(entity);
        this.world.func_72863_F().func_186028_c(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        if (this.placeInPortal(entity, yaw, 32, min, max, null)) {
            return;
        }
        BlockPos portalPos = this.makePortal(entity, 16, min, max, false);
        if (portalPos != null && this.placeInPortal(entity, yaw, 0, min, max, portalPos)) {
            return;
        }
        this.placeInPortal(entity, yaw, 0, min, max, this.makePortal(entity, 16, min, max, true));
    }

    public boolean placeInPortal(Entity entity, float rotationYaw, int checkRange, int checkMin, int checkMax, @Nullable BlockPos checkPos) {
        double portalDist = -1.0;
        BlockPos pos = BlockPos.field_177992_a;
        if (checkPos != null) {
            portalDist = 0.0;
            pos = checkPos;
        } else {
            BlockPos origin = new BlockPos(entity);
            BlockPos.MutableBlockPos current = new BlockPos.MutableBlockPos();
            current.func_181079_c(origin.func_177958_n(), checkMax, origin.func_177952_p());
            while (current.func_177956_o() > checkMin) {
                current.func_189536_c(EnumFacing.DOWN);
                if (this.world.func_180495_p((BlockPos)current).func_177230_c() != this.portalBlock) continue;
                while (this.world.func_180495_p((BlockPos)current.func_189536_c(EnumFacing.DOWN)).func_177230_c() == this.portalBlock) {
                }
                current.func_189536_c(EnumFacing.UP);
                double dist = current.func_177951_i((Vec3i)origin);
                if (!(portalDist < 0.0) && !(dist < portalDist)) continue;
                portalDist = dist;
                pos = new BlockPos((Vec3i)current);
            }
            if (portalDist < 0.0) {
                for (int range = 1; range <= checkRange; ++range) {
                    for (int i = -range; i <= range; ++i) {
                        for (int j = -range; j <= range; ++j) {
                            current.func_181079_c(origin.func_177958_n() + i, checkMax, origin.func_177952_p() + j);
                            while (current.func_177956_o() > checkMin) {
                                current.func_189536_c(EnumFacing.DOWN);
                                if (this.world.func_180495_p((BlockPos)current).func_177230_c() != this.portalBlock) continue;
                                while (this.world.func_180495_p((BlockPos)current.func_189536_c(EnumFacing.DOWN)).func_177230_c() == this.portalBlock) {
                                }
                                current.func_189536_c(EnumFacing.UP);
                                double dist = current.func_177951_i((Vec3i)origin);
                                if (!(portalDist < 0.0) && !(dist < portalDist)) continue;
                                portalDist = dist;
                                pos = new BlockPos((Vec3i)current);
                            }
                        }
                    }
                    if (portalDist >= 0.0) break;
                }
            }
        }
        if (portalDist >= 0.0) {
            IPortalCache cache = this.getCache((ICapabilityProvider)entity);
            Vec3d portalVec = (Vec3d)ObjectUtils.defaultIfNull((Object)cache.getLastPortalVec(), (Object)Vec3d.field_186680_a);
            EnumFacing teleportDirection = (EnumFacing)ObjectUtils.defaultIfNull((Object)cache.getTeleportDirection(), (Object)EnumFacing.NORTH);
            double posX = (double)pos.func_177958_n() + 0.5;
            double posZ = (double)pos.func_177952_p() + 0.5;
            BlockPattern.PatternHelper pattern = this.portalBlock.func_181089_f((World)this.world, pos);
            boolean flag1 = pattern.func_177669_b().func_176746_e().func_176743_c() == EnumFacing.AxisDirection.NEGATIVE;
            double d1 = pattern.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? (double)pattern.func_181117_a().func_177952_p() : (double)pattern.func_181117_a().func_177958_n();
            double posY = (double)(pattern.func_181117_a().func_177956_o() + 1) - portalVec.field_72448_b * (double)pattern.func_181119_e();
            if (flag1) {
                d1 += 1.0;
            }
            if (pattern.func_177669_b().func_176740_k() == EnumFacing.Axis.X) {
                posZ = d1 + (1.0 - portalVec.field_72450_a) * (double)pattern.func_181118_d() * (double)pattern.func_177669_b().func_176746_e().func_176743_c().func_179524_a();
            } else {
                posX = d1 + (1.0 - portalVec.field_72450_a) * (double)pattern.func_181118_d() * (double)pattern.func_177669_b().func_176746_e().func_176743_c().func_179524_a();
            }
            float f1 = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            if (pattern.func_177669_b().func_176734_d() == teleportDirection) {
                f1 = 1.0f;
                f2 = 1.0f;
            } else if (pattern.func_177669_b().func_176734_d() == teleportDirection.func_176734_d()) {
                f1 = -1.0f;
                f2 = -1.0f;
            } else if (pattern.func_177669_b().func_176734_d() == teleportDirection.func_176746_e()) {
                f3 = 1.0f;
                f4 = -1.0f;
            } else {
                f3 = -1.0f;
                f4 = 1.0f;
            }
            double mx = entity.field_70159_w;
            double mz = entity.field_70179_y;
            entity.field_70159_w = mx * (double)f1 + mz * (double)f4;
            entity.field_70179_y = mx * (double)f3 + mz * (double)f2;
            entity.field_70177_z = rotationYaw - (float)(teleportDirection.func_176734_d().func_176736_b() * 90) + (float)(pattern.func_177669_b().func_176736_b() * 90);
            entity.func_70634_a(posX, posY, posZ);
            return true;
        }
        return false;
    }

    @Nullable
    public BlockPos makePortal(Entity entity, int findRange, int findMin, int findMax, boolean force) {
        int j1;
        int i1;
        int k;
        int py;
        double zSize;
        double xSize;
        int pz;
        int px;
        int iz;
        int ix;
        int range;
        double portalDist = -1.0;
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)entity.field_70163_u);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        int x1 = x;
        int y1 = y;
        int z1 = z;
        int i = 0;
        int j = this.random.nextInt(4);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (range = 1; range <= findRange; ++range) {
            for (ix = -range; ix <= range; ++ix) {
                for (iz = -range; iz <= range; ++iz) {
                    px = x + ix;
                    pz = z + iz;
                    xSize = (double)px + 0.5 - entity.field_70165_t;
                    zSize = (double)pz + 0.5 - entity.field_70161_v;
                    block3: for (py = findMax - 1; py > findMin; --py) {
                        if (!this.world.func_175623_d((BlockPos)pos.func_181079_c(px, py, pz))) continue;
                        while (py > 0 && this.world.func_175623_d((BlockPos)pos.func_181079_c(px, py - 1, pz))) {
                            --py;
                        }
                        for (k = j; k < j + 4; ++k) {
                            i1 = k % 2;
                            j1 = 1 - i1;
                            if (k % 4 >= 2) {
                                i1 = -i1;
                                j1 = -j1;
                            }
                            for (int size1 = 0; size1 < 3; ++size1) {
                                for (int size2 = 0; size2 < 4; ++size2) {
                                    for (int height = -1; height < 4; ++height) {
                                        int checkX = px + (size2 - 1) * i1 + size1 * j1;
                                        int checkY = py + height;
                                        int checkZ = pz + (size2 - 1) * j1 - size1 * i1;
                                        pos.func_181079_c(checkX, checkY, checkZ);
                                        if (height < 0 && !this.world.func_180495_p((BlockPos)pos).func_185904_a().func_76220_a() || height >= 0 && !this.world.func_175623_d((BlockPos)pos)) continue block3;
                                    }
                                }
                            }
                            double ySize = (double)py + 0.5 - entity.field_70163_u;
                            double size = xSize * xSize + ySize * ySize + zSize * zSize;
                            if (!(portalDist < 0.0) && !(size < portalDist)) continue;
                            portalDist = size;
                            x1 = px;
                            y1 = py;
                            z1 = pz;
                            i = k % 4;
                        }
                    }
                }
            }
            if (portalDist >= 0.0) break;
        }
        if (portalDist < 0.0) {
            for (range = 1; range <= findRange; ++range) {
                for (ix = -range; ix <= range; ++ix) {
                    for (iz = -range; iz <= range; ++iz) {
                        px = x + ix;
                        pz = z + iz;
                        xSize = (double)px + 0.5 - entity.field_70165_t;
                        zSize = (double)pz + 0.5 - entity.field_70161_v;
                        block12: for (py = findMax - 1; py > findMin; --py) {
                            if (!this.world.func_175623_d((BlockPos)pos.func_181079_c(px, py, pz))) continue;
                            while (py > 0 && this.world.func_175623_d((BlockPos)pos.func_181079_c(px, py - 1, pz))) {
                                --py;
                            }
                            for (k = j; k < j + 2; ++k) {
                                i1 = k % 2;
                                j1 = 1 - i1;
                                for (int width = 0; width < 4; ++width) {
                                    for (int height = -1; height < 4; ++height) {
                                        int px1 = px + (width - 1) * i1;
                                        int py1 = py + height;
                                        int pz1 = pz + (width - 1) * j1;
                                        pos.func_181079_c(px1, py1, pz1);
                                        if (height < 0 && !this.world.func_180495_p((BlockPos)pos).func_185904_a().func_76220_a() || height >= 0 && !this.world.func_175623_d((BlockPos)pos)) continue block12;
                                    }
                                }
                                double ySize = (double)py + 0.5 - entity.field_70163_u;
                                double size = xSize * xSize + ySize * ySize + zSize * zSize;
                                if (!(portalDist < 0.0) && !(size < portalDist)) continue;
                                portalDist = size;
                                x1 = px;
                                y1 = py;
                                z1 = pz;
                                i = k % 2;
                            }
                        }
                    }
                }
                if (portalDist >= 0.0) break;
            }
        }
        if (!force && portalDist < 0.0) {
            return null;
        }
        int x2 = x1;
        int y2 = y1;
        int z2 = z1;
        int i12 = i % 2;
        int j12 = 1 - i12;
        if (i % 4 >= 2) {
            i12 = -i12;
            j12 = -j12;
        }
        if (portalDist < 0.0) {
            y2 = y1 = MathHelper.func_76125_a((int)y1, (int)findMin, (int)(findMax - 10));
            for (int size1 = -1; size1 <= 1; ++size1) {
                for (int size2 = 1; size2 < 3; ++size2) {
                    for (int height = -1; height < 3; ++height) {
                        int blockX = x2 + (size2 - 1) * i12 + size1 * j12;
                        int blockY = y2 + height;
                        int blockZ = z2 + (size2 - 1) * j12 - size1 * i12;
                        boolean flag = height < 0;
                        this.world.func_175656_a((BlockPos)pos.func_181079_c(blockX, blockY, blockZ), flag ? MOSSY_STONE : AIR);
                    }
                }
            }
        }
        IBlockState portalState = this.portalBlock.func_176223_P().func_177226_a((IProperty)BlockPortalCavern.field_176550_a, (Comparable)(i12 != 0 ? EnumFacing.Axis.X : EnumFacing.Axis.Z));
        BlockPos portalPos = null;
        for (int width = 0; width < 4; ++width) {
            for (int height = -1; height < 4; ++height) {
                int blockX = x2 + (width - 1) * i12;
                int blockY = y2 + height;
                int blockZ = z2 + (width - 1) * j12;
                boolean flag = width == 0 || width == 3 || height == -1 || height == 3;
                this.world.func_180501_a((BlockPos)pos.func_181079_c(blockX, blockY, blockZ), flag ? MOSSY_STONE : portalState, flag ? 2 : 18);
                if (width != 1 || height != 0) continue;
                portalPos = new BlockPos((double)blockX + 0.5, (double)blockY + 0.5, (double)blockZ + 0.5);
            }
        }
        return portalPos;
    }
}

