/*
 * Decompiled with CFR 0.152.
 */
package cavern.world;

import cavern.client.CaveMusics;
import cavern.config.AquaCavernConfig;
import cavern.config.manager.CaveBiomeManager;
import cavern.config.property.ConfigBiomeType;
import cavern.world.CaveDimensions;
import cavern.world.ChunkGeneratorAquaCavern;
import cavern.world.WorldProviderCavern;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderAquaCavern
extends WorldProviderCavern {
    @Override
    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorAquaCavern(this.field_76579_a);
    }

    @Override
    public DimensionType func_186058_p() {
        return CaveDimensions.AQUA_CAVERN;
    }

    @Override
    public ConfigBiomeType.Type getBiomeType() {
        return AquaCavernConfig.biomeType.getType();
    }

    @Override
    public int getWorldHeight() {
        return AquaCavernConfig.worldHeight;
    }

    @Override
    public CaveBiomeManager getBiomeManager() {
        return AquaCavernConfig.biomeManager;
    }

    @Override
    public int getMonsterSpawn() {
        return 0;
    }

    @Override
    public double getBrightness() {
        return AquaCavernConfig.caveBrightness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public MusicTicker.MusicType getMusicType() {
        return CaveMusics.AQUA_CAVES;
    }

    @Override
    public void func_186059_r() {
        WorldServer worldServer;
        if (this.field_76579_a instanceof WorldServer && (worldServer = (WorldServer)this.field_76579_a).func_72912_H().func_76067_t() != WorldType.field_180272_g) {
            this.entitySpawner.findChunksForSpawning(worldServer, false, true, worldServer.func_72912_H().func_82573_f() % 400L == 0L);
        }
    }

    @Override
    public Integer getMaxNumberOfCreature(WorldServer world, boolean spawnHostileMobs, boolean spawnPeacefulMobs, boolean spawnOnSetTickRate, EnumCreatureType type) {
        if (type == EnumCreatureType.WATER_CREATURE) {
            return 100;
        }
        return null;
    }
}

