/*
 * Decompiled with CFR 0.152.
 */
package cavern.world;

import cavern.client.CaveMusics;
import cavern.client.renderer.EmptyRenderer;
import cavern.config.CavernConfig;
import cavern.config.manager.CaveBiomeManager;
import cavern.config.property.ConfigBiomeType;
import cavern.world.BiomeProviderCavern;
import cavern.world.CaveDimensions;
import cavern.world.CaveEntitySpawner;
import cavern.world.ChunkGeneratorCavern;
import cavern.world.CustomHeightData;
import cavern.world.CustomSeedData;
import cavern.world.ICustomSeed;
import javax.annotation.Nullable;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderCavern
extends WorldProviderSurface
implements ICustomSeed,
CaveEntitySpawner.IWorldEntitySpawner {
    private CustomSeedData seedData;
    private CustomHeightData heightData;
    protected CaveEntitySpawner entitySpawner = new CaveEntitySpawner(this);

    protected void func_76572_b() {
        this.field_191067_f = false;
        this.seedData = this.field_76579_a instanceof WorldServer ? new CustomSeedData(this.field_76579_a.func_72912_H().getDimensionData(this.getDimension())) : new CustomSeedData();
        this.heightData = this.field_76579_a instanceof WorldServer ? new CustomHeightData(this.field_76579_a.func_72912_H().getDimensionData(this.getDimension())) : null;
        CaveBiomeManager manager = this.getBiomeManager();
        if (manager != null) {
            switch (this.getBiomeType()) {
                case SQUARE: {
                    this.field_76578_c = new BiomeProviderCavern(this.field_76579_a, 1, manager);
                    return;
                }
                case LARGE_SQUARE: {
                    this.field_76578_c = new BiomeProviderCavern(this.field_76579_a, 5, manager);
                    return;
                }
            }
        }
        if (this.field_76578_c == null) {
            this.field_76578_c = this.field_76579_a.func_72912_H().func_76067_t().getBiomeProvider(this.field_76579_a);
        }
    }

    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorCavern(this.field_76579_a);
    }

    public DimensionType func_186058_p() {
        return CaveDimensions.CAVERN;
    }

    public ConfigBiomeType.Type getBiomeType() {
        return CavernConfig.biomeType.getType();
    }

    @Override
    public CustomSeedData getSeedData() {
        return this.seedData;
    }

    public long getSeed() {
        if (this.seedData != null) {
            if (this.field_76579_a instanceof WorldServer) {
                return this.seedData.getSeed();
            }
            return this.seedData.getSeedValue(this.field_76579_a.func_72912_H().func_76063_b());
        }
        return super.getSeed();
    }

    public int getWorldHeight() {
        return CavernConfig.worldHeight;
    }

    public int getActualHeight() {
        if (this.heightData != null) {
            return this.heightData.getHeight(this.getWorldHeight());
        }
        return super.getActualHeight();
    }

    @Nullable
    public CaveBiomeManager getBiomeManager() {
        return CavernConfig.biomeManager;
    }

    public int getMonsterSpawn() {
        return CavernConfig.monsterSpawn;
    }

    public double getBrightness() {
        return CavernConfig.caveBrightness;
    }

    protected void func_76556_a() {
        float f = (float)this.getBrightness();
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            this.field_76573_f[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
    }

    public boolean func_76569_d() {
        return false;
    }

    public boolean func_76566_a(int x, int z) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public MusicTicker.MusicType getMusicType() {
        return CaveMusics.CAVES;
    }

    @SideOnly(value=Side.CLIENT)
    public float[] func_76560_a(float angle, float ticks) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float angle, float ticks) {
        return new Vec3d(0.01, 0.01, 0.01);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76561_g() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        return new Vec3d(0.01, 0.01, 0.01);
    }

    public int func_76557_i() {
        return 10;
    }

    public boolean shouldClientCheckLighting() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            this.setSkyRenderer(EmptyRenderer.INSTANCE);
        }
        return super.getSkyRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getCloudRenderer() {
        if (super.getCloudRenderer() == null) {
            this.setCloudRenderer(EmptyRenderer.INSTANCE);
        }
        return super.getCloudRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getWeatherRenderer() {
        if (super.getWeatherRenderer() == null) {
            this.setWeatherRenderer(EmptyRenderer.INSTANCE);
        }
        return super.getWeatherRenderer();
    }

    public boolean shouldMapSpin(String entity, double posX, double posY, double posZ) {
        return posY < 0.0 || posY >= (double)this.getActualHeight();
    }

    public BlockPos getSpawnPoint() {
        return BlockPos.field_177992_a.func_177981_b(50);
    }

    public BlockPos getRandomizedSpawnPoint() {
        return this.getSpawnPoint();
    }

    public boolean isDaytime() {
        return false;
    }

    public double getHorizon() {
        return this.getActualHeight();
    }

    public WorldProvider.WorldSleepResult canSleepAt(EntityPlayer player, BlockPos pos) {
        return WorldProvider.WorldSleepResult.ALLOW;
    }

    public boolean canDoLightning(Chunk chunk) {
        return false;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return false;
    }

    public boolean func_186056_c(int x, int z) {
        return true;
    }

    public void func_186057_q() {
        NBTTagCompound nbt;
        if (this.seedData != null) {
            nbt = this.field_76579_a.func_72912_H().getDimensionData(this.getDimension());
            this.field_76579_a.func_72912_H().setDimensionData(this.getDimension(), this.seedData.getCompound(nbt));
        }
        if (this.heightData != null) {
            nbt = this.field_76579_a.func_72912_H().getDimensionData(this.getDimension());
            this.field_76579_a.func_72912_H().setDimensionData(this.getDimension(), this.heightData.getCompound(nbt));
        }
    }

    public void func_186059_r() {
        WorldServer worldServer;
        if (this.getMonsterSpawn() > 0 && this.field_76579_a instanceof WorldServer && (worldServer = (WorldServer)this.field_76579_a).func_82736_K().func_82766_b("doMobSpawning") && worldServer.func_72912_H().func_76067_t() != WorldType.field_180272_g) {
            boolean spawnHostileMobs;
            MinecraftServer server = worldServer.func_73046_m();
            boolean bl = spawnHostileMobs = worldServer.func_175659_aa() != EnumDifficulty.PEACEFUL;
            if (server != null && !server.func_71264_H() && server.func_71262_S() && server instanceof DedicatedServer) {
                spawnHostileMobs = ((DedicatedServer)server).func_71193_K();
            }
            this.entitySpawner.findChunksForSpawning(worldServer, spawnHostileMobs, false, worldServer.func_72912_H().func_82573_f() % 400L == 0L);
        }
    }

    @Override
    public Integer getMaxNumberOfCreature(WorldServer world, boolean spawnHostileMobs, boolean spawnPeacefulMobs, boolean spawnOnSetTickRate, EnumCreatureType type) {
        if (!type.func_75599_d()) {
            return this.getMonsterSpawn();
        }
        return null;
    }
}

