/*
 * Decompiled with CFR 0.152.
 */
package cavern.world.gen;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenCaves;

public class MapGenCavernCaves
extends MapGenCaves {
    protected static final IBlockState BLK_STONE = Blocks.field_150348_b.func_176223_P();
    protected static final IBlockState BLK_DIRT = Blocks.field_150346_d.func_176223_P();
    protected static final IBlockState BLK_GRASS = Blocks.field_150349_c.func_176223_P();
    protected static final IBlockState BLK_WATER = Blocks.field_150355_j.func_176223_P();

    protected void func_180702_a(long caveSeed, int chunkX, int chunkZ, ChunkPrimer primer, double blockX, double blockY, double blockZ, float scale, float leftRightRadian, float upDownRadian, int currentY, int targetY, double scaleHeight) {
        boolean chance;
        Random random = new Random(caveSeed);
        int worldHeight = this.field_75039_c.func_72940_L();
        double centerX = chunkX * 16 + 8;
        double centerZ = chunkZ * 16 + 8;
        float leftRightChange = 0.0f;
        float upDownChange = 0.0f;
        if (targetY <= 0) {
            int blockRangeY = this.field_75040_a * 16 - 16;
            targetY = blockRangeY - random.nextInt(blockRangeY / 4);
        }
        boolean createFinalRoom = false;
        if (currentY == -1) {
            currentY = targetY / 2;
            createFinalRoom = true;
        }
        int nextInterHeight = random.nextInt(targetY / 2) + targetY / 4;
        boolean bl = chance = random.nextInt(10) == 0;
        while (currentY < targetY) {
            double roomWidth = 2.0 + (double)(MathHelper.func_76126_a((float)((float)currentY * (float)Math.PI / (float)targetY)) * scale);
            double roomHeight = roomWidth * scaleHeight;
            float moveHorizontal = MathHelper.func_76134_b((float)upDownRadian);
            float moveVertical = MathHelper.func_76126_a((float)upDownRadian);
            blockX += (double)(MathHelper.func_76134_b((float)leftRightRadian) * moveHorizontal);
            blockY += (double)moveVertical;
            blockZ += (double)(MathHelper.func_76126_a((float)leftRightRadian) * moveHorizontal);
            upDownRadian = chance ? (upDownRadian *= 0.95f) : (upDownRadian *= 0.8f);
            upDownRadian += upDownChange * 0.1f;
            leftRightRadian += leftRightChange * 0.1f;
            upDownChange *= 0.9f;
            leftRightChange *= 0.75f;
            upDownChange += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            leftRightChange += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (!createFinalRoom && currentY == nextInterHeight && scale > 1.0f && targetY > 0) {
                this.func_180702_a(random.nextLong(), chunkX, chunkZ, primer, blockX, blockY, blockZ, random.nextFloat() * 0.5f + 0.5f, leftRightRadian - 1.5707964f, upDownRadian / 3.0f, currentY, targetY, 1.0);
                this.func_180702_a(random.nextLong(), chunkX, chunkZ, primer, blockX, blockY, blockZ, random.nextFloat() * 0.5f + 0.5f, leftRightRadian + 1.5707964f, upDownRadian / 3.0f, currentY, targetY, 1.0);
                return;
            }
            if (createFinalRoom || random.nextInt(4) != 0) {
                double distanceX = blockX - centerX;
                double distanceZ = blockZ - centerZ;
                double distanceY = targetY - currentY;
                double maxDistance = scale + 20.0f;
                if (distanceX * distanceX + distanceZ * distanceZ - distanceY * distanceY > maxDistance * maxDistance) {
                    return;
                }
                if (blockX >= centerX - 16.0 - roomWidth * 2.0 && blockZ >= centerZ - 16.0 - roomWidth * 2.0 && blockX <= centerX + 16.0 + roomWidth * 2.0 && blockZ <= centerZ + 16.0 + roomWidth * 2.0) {
                    int xLow = Math.max(MathHelper.func_76128_c((double)(blockX - roomWidth)) - chunkX * 16 - 1, 0);
                    int xHigh = Math.min(MathHelper.func_76128_c((double)(blockX + roomWidth)) - chunkX * 16 + 1, 16);
                    int yLow = Math.max(MathHelper.func_76128_c((double)(blockY - roomHeight)) - 1, 1);
                    int yHigh = Math.min(MathHelper.func_76128_c((double)(blockY + roomHeight)) + 1, worldHeight - 4);
                    int zLow = Math.max(MathHelper.func_76128_c((double)(blockZ - roomWidth)) - chunkZ * 16 - 1, 0);
                    int zHigh = Math.min(MathHelper.func_76128_c((double)(blockZ + roomWidth)) - chunkZ * 16 + 1, 16);
                    for (int x = xLow; x < xHigh; ++x) {
                        double xScale = ((double)(chunkX * 16 + x) + 0.5 - blockX) / roomWidth;
                        for (int z = zLow; z < zHigh; ++z) {
                            double zScale = ((double)(chunkZ * 16 + z) + 0.5 - blockZ) / roomWidth;
                            if (!(xScale * xScale + zScale * zScale < 1.0)) continue;
                            for (int y = yHigh - 1; y >= yLow; --y) {
                                double yScale = ((double)y + 0.5 - blockY) / roomHeight;
                                if (!(yScale > -0.7) || !(xScale * xScale + yScale * yScale + zScale * zScale < 1.0)) continue;
                                this.digBlock(primer, x, y, z, chunkX, chunkZ, false, null, null);
                            }
                        }
                    }
                    if (createFinalRoom) break;
                }
            }
            ++currentY;
        }
    }

    protected void func_180701_a(World world, int chunkX, int chunkZ, int x, int z, ChunkPrimer primer) {
        int worldHeight = world.field_73011_w.getActualHeight();
        int chance = this.field_75038_b.nextInt(this.field_75038_b.nextInt(this.field_75038_b.nextInt(25) + 1) + 1);
        if (this.field_75038_b.nextInt(4) != 0) {
            chance = 0;
        }
        for (int i = 0; i < chance; ++i) {
            double blockX = chunkX * 16 + this.field_75038_b.nextInt(16);
            double blockY = this.field_75038_b.nextInt(this.field_75038_b.nextInt(worldHeight - 8) + 8);
            double blockZ = chunkZ * 16 + this.field_75038_b.nextInt(16);
            int count = 1;
            if (this.field_75038_b.nextInt(4) == 0) {
                this.func_180703_a(this.field_75038_b.nextLong(), x, z, primer, blockX, blockY, blockZ);
                count += this.field_75038_b.nextInt(4);
            }
            for (int j = 0; j < count; ++j) {
                float leftRightRadian = this.field_75038_b.nextFloat() * (float)Math.PI * 2.0f;
                float upDownRadian = (this.field_75038_b.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float scale = this.field_75038_b.nextFloat() * 3.0f + this.field_75038_b.nextFloat();
                if (this.field_75038_b.nextInt(8) == 0) {
                    scale *= this.field_75038_b.nextFloat() * this.field_75038_b.nextFloat() * 3.5f + 1.0f;
                }
                this.func_180702_a(this.field_75038_b.nextLong(), x, z, primer, blockX, blockY, blockZ, scale, leftRightRadian, upDownRadian, 0, 0, 1.15);
            }
        }
    }

    protected void digBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ, boolean foundTop, IBlockState state, IBlockState up) {
        if (y - 1 < 10) {
            data.func_177855_a(x, y, z, field_186126_a);
        } else {
            data.func_177855_a(x, y, z, field_186127_b);
        }
    }
}

