/*
 * Decompiled with CFR 0.152.
 */
package cavern.world.gen;

import cavern.config.Config;
import cavern.config.manager.CaveVein;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;

public class VeinGenerator {
    private final List<? extends CaveVein> veins;

    public VeinGenerator(List<? extends CaveVein> veins) {
        this.veins = veins;
    }

    public void generate(World world, Random rand, Biome[] biomes, ChunkPrimer primer) {
        int worldHeight = world.func_72940_L();
        for (CaveVein caveVein : this.veins) {
            if (caveVein == null || caveVein.getWeight() <= 0 || caveVein.getSize() <= 0) continue;
            for (int veinCount = 0; veinCount < caveVein.getWeight(); ++veinCount) {
                if (caveVein.getChance() < 1.0 && rand.nextDouble() < caveVein.getChance()) continue;
                int yChance = rand.nextInt(3) + 3;
                int originX = rand.nextInt(16);
                int originY = MathHelper.func_76136_a((Random)rand, (int)caveVein.getMinHeight(), (int)caveVein.getMaxHeight());
                int originZ = rand.nextInt(16);
                int x = originX;
                int y = originY;
                int z = originZ;
                Object prev = null;
                for (int oreCount = 0; oreCount < caveVein.getSize(); ++oreCount) {
                    Biome biome;
                    String[] targetBiomes;
                    IBlockState state;
                    int checkCount = 0;
                    while (oreCount > 0) {
                        EnumFacing.Axis next;
                        int checkX = x;
                        int checkY = y;
                        int checkZ = z;
                        if (prev == null) {
                            next = rand.nextInt(yChance) == 0 ? EnumFacing.Axis.Y : (rand.nextBoolean() ? EnumFacing.Axis.X : EnumFacing.Axis.Z);
                        } else {
                            switch (1.$SwitchMap$net$minecraft$util$EnumFacing$Axis[prev.ordinal()]) {
                                case 1: {
                                    next = rand.nextInt(yChance - 1) == 0 ? EnumFacing.Axis.Y : EnumFacing.Axis.Z;
                                    break;
                                }
                                case 2: {
                                    next = rand.nextBoolean() ? EnumFacing.Axis.X : EnumFacing.Axis.Z;
                                    break;
                                }
                                case 3: {
                                    next = rand.nextInt(yChance - 1) == 0 ? EnumFacing.Axis.Y : EnumFacing.Axis.X;
                                    break;
                                }
                                default: {
                                    next = rand.nextInt(yChance) == 0 ? EnumFacing.Axis.Y : (rand.nextBoolean() ? EnumFacing.Axis.X : EnumFacing.Axis.Z);
                                }
                            }
                        }
                        switch (next) {
                            case X: {
                                if (x <= 0) {
                                    checkX = 1;
                                    break;
                                }
                                if (x >= 15) {
                                    checkX = 14;
                                    break;
                                }
                                checkX = x + (rand.nextBoolean() ? 1 : -1);
                                break;
                            }
                            case Y: {
                                if (y <= 0) {
                                    checkY = 1;
                                    break;
                                }
                                if (y >= worldHeight - 1) {
                                    checkY = worldHeight - 2;
                                    break;
                                }
                                checkY = y + (rand.nextBoolean() ? 1 : -1);
                                break;
                            }
                            case Z: {
                                checkZ = z <= 0 ? 1 : (z >= 15 ? 14 : z + (rand.nextBoolean() ? 1 : -1));
                            }
                        }
                        IBlockState state2 = primer.func_177856_a(checkX, checkY, checkZ);
                        if (state2.func_177230_c() == caveVein.getTarget().getBlock() && state2.func_177230_c().func_176201_c(state2) == caveVein.getTarget().getMeta()) {
                            x = checkX;
                            y = checkY;
                            z = checkZ;
                            break;
                        }
                        if (++checkCount <= 10) continue;
                        break;
                    }
                    if ((state = primer.func_177856_a(x, y, z)).func_177230_c() != caveVein.getTarget().getBlock() || state.func_177230_c().func_176201_c(state) != caveVein.getTarget().getMeta() || (targetBiomes = caveVein.getBiomes()) != null && targetBiomes.length > 0 && ((biome = biomes[x * 16 + z]) == null || Config.containsBiome(targetBiomes, biome))) continue;
                    primer.func_177855_a(x, y, z, caveVein.getBlockMeta().getBlockState());
                }
            }
        }
    }
}

