/*
 * Decompiled with CFR 0.152.
 */
package co.uk.silvania.roads;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.storage.ISaveHandler;

public class NBTConfig {
    public static File getConfigFolder() {
        return new File(new File(Minecraft.func_71410_x().field_71412_D, "config"), "flenixroads");
    }

    public static File getWorldConfig(World world) {
        return new File(NBTConfig.getWorldDir(world), "flenixroads");
    }

    public static File getWorldDir(World world) {
        try {
            ISaveHandler worldsaver = world.func_72860_G();
            IChunkLoader loader = worldsaver.func_75763_a(world.field_73011_w);
            File file = (File)ReflectionHelper.getPrivateValue(AnvilChunkLoader.class, (Object)((AnvilChunkLoader)loader), (int)3);
            return file.getName().contains("DIM") ? file.getParentFile() : file;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static File createAndGetNBTFile(File f) {
        try {
            CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(f));
        }
        catch (Exception e) {
            NBTTagCompound cmp = new NBTTagCompound();
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)cmp, (OutputStream)new FileOutputStream(f));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return f;
    }

    private static boolean injectNBTToFile(NBTTagCompound cmp, File f) {
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)cmp, (OutputStream)new FileOutputStream(f));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean saveConfig(NBTTagCompound cmp, File f) {
        return NBTConfig.injectNBTToFile(cmp, f);
    }

    public static NBTTagCompound getTagCompoundInFile(File f) {
        try {
            NBTTagCompound cmp = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(f));
            return cmp;
        }
        catch (IOException e) {
            NBTTagCompound cmp = new NBTTagCompound();
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)cmp, (OutputStream)new FileOutputStream(f));
                return NBTConfig.getTagCompoundInFile(f);
            }
            catch (IOException e1) {
                return null;
            }
        }
    }
}

