/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads;

import com.silvaniastudios.roads.CommonProxy;
import com.silvaniastudios.roads.GuiHandler;
import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.WorldGen;
import com.silvaniastudios.roads.blocks.FRBlocks;
import com.silvaniastudios.roads.blocks.tileentities.recipes.RecipeRegistry;
import com.silvaniastudios.roads.fluids.FRFluids;
import com.silvaniastudios.roads.items.FRItems;
import com.silvaniastudios.roads.items.RoadsFuelHandler;
import com.silvaniastudios.roads.network.ClientGuiUpdatePacket;
import com.silvaniastudios.roads.network.CompactorUpdatePacket;
import com.silvaniastudios.roads.network.FabricatorUpdatePacket;
import com.silvaniastudios.roads.network.PaintGunUpdatePacket;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="furenikusroads", name="Fureniku's Roads", version="1.1.9", acceptedMinecraftVersions="[1.12.2]")
public class FurenikusRoads {
    public static final String MODID = "furenikusroads";
    public static final String VERSION = "1.1.9";
    @Mod.Instance(value="furenikusroads")
    public static FurenikusRoads instance;
    public static Logger logger;
    @SidedProxy(clientSide="com.silvaniastudios.roads.client.ClientProxy", serverSide="com.silvaniastudios.roads.CommonProxy")
    public static CommonProxy proxy;
    public static final SimpleNetworkWrapper PACKET_CHANNEL;
    public static CreativeTabs tab_roads;
    public static CreativeTabs tab_sidewalks;
    public static CreativeTabs tab_road_parts;
    public static CreativeTabs tab_tools;
    public static CreativeTabs tab_paint_lines;
    public static CreativeTabs tab_paint_icons;
    public static CreativeTabs tab_paint_letters;
    public static CreativeTabs tab_paint_text;
    public static CreativeTabs tab_paint_junction;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
        logger = event.getModLog();
        FRBlocks.registerPaintGunEntries();
        if (RoadsConfig.general.genLimestone) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGen(), (int)3);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        PACKET_CHANNEL.registerMessage(PaintGunUpdatePacket.Handler.class, PaintGunUpdatePacket.class, 0, Side.SERVER);
        PACKET_CHANNEL.registerMessage(CompactorUpdatePacket.Handler.class, CompactorUpdatePacket.class, 1, Side.SERVER);
        PACKET_CHANNEL.registerMessage(FabricatorUpdatePacket.Handler.class, FabricatorUpdatePacket.class, 2, Side.SERVER);
        PACKET_CHANNEL.registerMessage(ClientGuiUpdatePacket.Handler.class, ClientGuiUpdatePacket.class, 4, Side.CLIENT);
        FRFluids.registerFluids();
        MinecraftForge.EVENT_BUS.register(FRItems.class);
        GameRegistry.registerFuelHandler((IFuelHandler)new RoadsFuelHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        RecipeRegistry.init();
    }

    public static void debug(int level, String str) {
        if (RoadsConfig.general.debugLevel >= level) {
            System.out.println("[Fureniku's Roads] " + str);
        }
    }

    static {
        PACKET_CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        tab_roads = new CreativeTabs("tab_roads"){

            public ItemStack func_78016_d() {
                return new ItemStack((Block)FRBlocks.road_block_standard, 1, 11);
            }
        };
        tab_sidewalks = new CreativeTabs("tab_sidewalks"){

            public ItemStack func_78016_d() {
                return new ItemStack((Block)FRBlocks.street_block_a, 1, 3);
            }
        };
        tab_road_parts = new CreativeTabs("tab_road_parts"){

            public ItemStack func_78016_d() {
                return new ItemStack((Block)FRBlocks.tactile_crossing_bumps, 1, 0);
            }
        };
        tab_tools = new CreativeTabs("tab_tools"){

            public ItemStack func_78016_d() {
                return new ItemStack((Item)FRItems.paint_gun, 1, 0);
            }
        };
        tab_paint_lines = new CreativeTabs("tab_paint_lines"){

            public ItemStack func_78016_d() {
                return new ItemStack((Block)FRBlocks.line_white_straight_thick, 1, 0);
            }
        };
        tab_paint_icons = new CreativeTabs("tab_paint_icons"){

            public ItemStack func_78016_d() {
                return new ItemStack((Block)FRBlocks.white_wheelchair_icon, 1, 0);
            }
        };
        tab_paint_letters = new CreativeTabs("tab_paint_letters"){

            public ItemStack func_78016_d() {
                return new ItemStack((Block)FRBlocks.paint_letter_white_ab, 1, 0);
            }
        };
        tab_paint_text = new CreativeTabs("tab_paint_text"){

            public ItemStack func_78016_d() {
                return new ItemStack((Block)FRBlocks.white_slow, 1, 0);
            }
        };
        tab_paint_junction = new CreativeTabs("tab_paint_junction"){

            public ItemStack func_78016_d() {
                return new ItemStack((Block)FRBlocks.white_junction_fork_chevron_mid, 1, 0);
            }
        };
        FluidRegistry.enableUniversalBucket();
    }

    @Mod.EventBusSubscriber
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            FRItems.register((IForgeRegistry<Item>)event.getRegistry());
            FRBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
        }

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            FRBlocks.register((IForgeRegistry<Block>)event.getRegistry());
            FRBlocks.registerTileEntities();
        }

        @SubscribeEvent
        public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        }

        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            FRItems.registerModels();
            FRBlocks.registerModels();
        }
    }
}

