/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks;

import com.silvaniastudios.roads.blocks.GenericDecorativeBlock;
import com.silvaniastudios.roads.blocks.enums.EnumMeta;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RetractableBollardBlock
extends GenericDecorativeBlock {
    float v = 0.0625f;

    public RetractableBollardBlock(String name) {
        super(name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < EnumMeta.values().length; ++i) {
            if (i % 2 != 0) continue;
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        int meta = this.func_176201_c(state);
        if (world.func_175640_z(pos) && meta % 2 == 0) {
            world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)META_ID, (Comparable)((Object)EnumMeta.byMetadata(meta + 1))));
        } else if (!world.func_175640_z(pos) && meta % 2 != 0) {
            world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)META_ID, (Comparable)((Object)EnumMeta.byMetadata(meta - 1))));
        }
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int meta = this.func_176201_c(state);
        return new AxisAlignedBB(0.5 - this.getWidth(meta) / 2.0, -1.0 + this.getBlockBelowHeight(worldIn, pos), 0.5 - this.getWidth(meta) / 2.0, 0.5 + this.getWidth(meta) / 2.0, -1.0 + this.getBlockBelowHeight(worldIn, pos) + this.getHeight(meta), 0.5 + this.getWidth(meta) / 2.0);
    }

    @Override
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int meta = this.func_176201_c(state);
        return new AxisAlignedBB(0.5 - this.getWidth(meta) / 2.0, -1.0 + this.getBlockBelowHeight(worldIn, pos), 0.5 - this.getWidth(meta) / 2.0, 0.5 + this.getWidth(meta) / 2.0, -1.0 + this.getBlockBelowHeight(worldIn, pos) + this.getCollisionHeight(meta), 0.5 + this.getWidth(meta) / 2.0);
    }

    private double getWidth(int meta) {
        if (meta < 8) {
            return 8.0f * this.v;
        }
        return 5.0f * this.v;
    }

    private double getHeight(int meta) {
        if (meta == 0 || meta == 2) {
            return 12.0f * this.v;
        }
        if (meta == 4 || meta == 6) {
            return 1.0;
        }
        if (meta == 8 || meta == 10 || meta == 12 || meta == 14) {
            return 1.0;
        }
        return meta < 8 ? 0.5 * (double)this.v : (double)(1.0f * this.v);
    }

    private double getCollisionHeight(int meta) {
        if (meta == 0 || meta == 2 || meta == 4 || meta == 6 || meta == 8 || meta == 10 || meta == 12 || meta == 14) {
            return 1.5;
        }
        return meta < 8 ? 0.5 * (double)this.v : (double)(1.0f * this.v);
    }
}

