/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.paint;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.enums.IMetaBlockName;
import com.silvaniastudios.roads.blocks.paint.ArrowLinePaintBlock;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LinePaintBlock
extends PaintBlockBase
implements IMetaBlockName {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool DEFAULTS = PropertyBool.func_177716_a((String)"zz_default_stuff");
    public static final PropertyEnum<EnumRotation> FACING = PropertyEnum.func_177709_a((String)"facing", EnumRotation.class);

    public LinePaintBlock(String name) {
        super(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DEFAULTS, (Comparable)Boolean.valueOf(true)).func_177226_a(FACING, (Comparable)((Object)EnumRotation.ns)));
        this.func_149647_a(FurenikusRoads.tab_paint_lines);
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return stack.func_77952_i() + "";
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (meta < 2) {
            if (placer.func_174811_aO() == EnumFacing.EAST || placer.func_174811_aO() == EnumFacing.WEST) {
                return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumRotation.ew));
            }
            return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumRotation.ns));
        }
        return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumRotation.connect));
    }

    public boolean canConnectTo(IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block instanceof LinePaintBlock || block instanceof ArrowLinePaintBlock;
    }

    private boolean canLineConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos offset = pos.func_177972_a(facing);
        return this.canConnectTo(world, offset, facing.func_176734_d()) || this.canConnectTo(world, offset.func_177972_a(EnumFacing.DOWN), facing.func_176734_d()) || this.canConnectTo(world, offset.func_177972_a(EnumFacing.UP), facing.func_176734_d());
    }

    public int func_176201_c(IBlockState state) {
        if (((EnumRotation)((Object)state.func_177229_b(FACING))).equals((Object)EnumRotation.ns)) {
            return 0;
        }
        if (((EnumRotation)((Object)state.func_177229_b(FACING))).equals((Object)EnumRotation.ew)) {
            return 1;
        }
        return 2;
    }

    public IBlockState func_176203_a(int meta) {
        if (meta == 0) {
            return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumRotation.ns));
        }
        if (meta == 1) {
            return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumRotation.ew));
        }
        return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumRotation.connect));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, WEST, SOUTH, DEFAULTS, FACING});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canLineConnectTo(worldIn, pos, EnumFacing.NORTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canLineConnectTo(worldIn, pos, EnumFacing.EAST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canLineConnectTo(worldIn, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canLineConnectTo(worldIn, pos, EnumFacing.WEST)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 0));
        items.add((Object)new ItemStack((Block)this, 1, 2));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)2, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory_2"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)3, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory_2"));
    }

    public static enum EnumRotation implements IStringSerializable
    {
        ns("north_south"),
        ew("east_west"),
        connect("connect");

        private final String name;

        private EnumRotation(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static EnumRotation byMetadata(int meta) {
            if (meta == 0) {
                return ns;
            }
            if (meta == 1) {
                return ew;
            }
            return connect;
        }
    }
}

