/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.paint;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.BlockBase;
import com.silvaniastudios.roads.blocks.CurbBlock;
import com.silvaniastudios.roads.blocks.NonPaintRoadTopBlock;
import com.silvaniastudios.roads.items.FRItems;
import com.silvaniastudios.roads.items.PaintGun;
import com.silvaniastudios.roads.items.PaintGunItemRegistry;
import com.silvaniastudios.roads.network.PaintGunUpdatePacket;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PaintBlockBase
extends BlockBase {
    public PaintBlockBase(String name) {
        super(name, Material.field_151580_n);
        this.func_149711_c(2.0f);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemStack.field_190927_a.func_77973_b();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        Block block;
        ItemStack item = player.func_184586_b(EnumHand.MAIN_HAND);
        if (item.func_77973_b() instanceof PaintGun && this.func_185473_a(world, pos, state).func_77973_b() instanceof ItemBlock && item.func_77942_o() && (block = ((ItemBlock)this.func_185473_a(world, pos, state).func_77973_b()).func_179223_d()) instanceof PaintBlockBase) {
            PaintBlockBase whiteBlock = PaintGunItemRegistry.getWhite((PaintBlockBase)block);
            NBTTagCompound nbt = item.func_77978_p();
            int pageId = nbt.func_74762_e("pageId");
            int id = nbt.func_74762_e("selectedId");
            int selMeta = nbt.func_74762_e("selMeta");
            int selectedColour = nbt.func_74762_e("colour");
            boolean isLarge = nbt.func_74767_n("isLarge");
            int blockMeta = this.func_176201_c(state);
            int lineId = PaintGunItemRegistry.findLineId(whiteBlock, blockMeta);
            int iconId = PaintGunItemRegistry.findIconId(whiteBlock, blockMeta);
            int letterId = PaintGunItemRegistry.findLetterId(whiteBlock, blockMeta);
            int textId = PaintGunItemRegistry.findTextId(whiteBlock, blockMeta);
            int junctionId = PaintGunItemRegistry.findJunctionId(whiteBlock, blockMeta);
            if (lineId <= PaintGunItemRegistry.lines.size() && lineId >= 0) {
                pageId = 1;
                id = lineId;
                selMeta = PaintGunItemRegistry.linesMeta.get(lineId);
            }
            if (iconId <= PaintGunItemRegistry.icons.size() && iconId >= 0) {
                pageId = 2;
                id = iconId;
                selMeta = PaintGunItemRegistry.iconsMeta.get(iconId);
            }
            if (letterId <= PaintGunItemRegistry.letters.size() && letterId >= 0) {
                pageId = 3;
                id = letterId;
                selMeta = PaintGunItemRegistry.lettersMeta.get(letterId);
            }
            if (textId <= PaintGunItemRegistry.text.size() && textId >= 0) {
                pageId = 4;
                id = textId;
                selMeta = PaintGunItemRegistry.textMeta.get(textId);
                if (selMeta == 4) {
                    isLarge = true;
                }
            }
            if (junctionId <= PaintGunItemRegistry.junction.size() && junctionId >= 0) {
                pageId = 5;
                id = junctionId;
                selMeta = PaintGunItemRegistry.junctionMeta.get(junctionId);
            }
            FurenikusRoads.PACKET_CHANNEL.sendToServer((IMessage)new PaintGunUpdatePacket(id, selMeta, selectedColour, pageId, isLarge));
            return ItemStack.field_190927_a;
        }
        return this.func_185473_a(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Item item = player.func_184586_b(hand).func_77973_b();
        if (item.equals((Object)FRItems.paint_scraper)) {
            world.func_175698_g(pos);
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (world.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c() instanceof BlockAir && RoadsConfig.general.breakPaintOnBlockBreak) {
            world.func_175698_g(pos);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, -1.0 + this.getBlockBelowHeight(source, pos), 0.0, 1.0, -1.0 + this.getBlockBelowHeight(source, pos) + 0.0625, 1.0);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XYZ;
    }

    public Vec3d func_190949_e(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        double offset = 1.0 - this.getBlockBelowHeight(worldIn, pos);
        return new Vec3d(0.0, -offset, 0.0);
    }

    public double getBlockBelowHeight(IBlockAccess worldIn, BlockPos pos) {
        IBlockState underState = worldIn.func_180495_p(pos.func_177972_a(EnumFacing.DOWN));
        Block underBlock = underState.func_177230_c();
        double extraOffset = 0.0;
        if (underBlock instanceof PaintBlockBase || underBlock instanceof NonPaintRoadTopBlock || underBlock instanceof CurbBlock) {
            extraOffset = 0.062;
        }
        return underBlock.func_185496_a((IBlockState)underState, (IBlockAccess)worldIn, (BlockPos)pos.func_177972_a((EnumFacing)EnumFacing.DOWN)).field_72337_e - extraOffset;
    }
}

