/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.paint;

import com.google.common.base.Predicate;
import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.enums.EnumConnectSideLine;
import com.silvaniastudios.roads.blocks.enums.IMetaBlockName;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SideLinePaintBlock
extends PaintBlockBase
implements IMetaBlockName {
    public static final PropertyEnum<EnumConnectSideLine> CONNECT_LEFT = PropertyEnum.func_177709_a((String)"connect_left", EnumConnectSideLine.class);
    public static final PropertyEnum<EnumConnectSideLine> CONNECT_RIGHT = PropertyEnum.func_177709_a((String)"connect_right", EnumConnectSideLine.class);
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"zz_facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public SideLinePaintBlock(String name) {
        super(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(CONNECT_LEFT, (Comparable)((Object)EnumConnectSideLine.NONE)).func_177226_a(CONNECT_RIGHT, (Comparable)((Object)EnumConnectSideLine.NONE)));
        this.func_149647_a(FurenikusRoads.tab_paint_lines);
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return stack.func_77952_i() + "";
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing == EnumFacing.DOWN || enumfacing == EnumFacing.UP) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, CONNECT_LEFT, CONNECT_RIGHT});
    }

    private EnumConnectSideLine canLineConnectTo(IBlockAccess world, BlockPos pos, boolean leftSide) {
        IBlockState state = world.func_180495_p(pos);
        int meta = this.func_176201_c(state);
        IBlockState stateNorth = world.func_180495_p(pos);
        IBlockState stateEast = world.func_180495_p(pos);
        IBlockState stateSouth = world.func_180495_p(pos);
        IBlockState stateWest = world.func_180495_p(pos);
        boolean blockNorth = world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH)).func_177230_c() instanceof SideLinePaintBlock;
        boolean blockEast = world.func_180495_p(pos.func_177972_a(EnumFacing.EAST)).func_177230_c() instanceof SideLinePaintBlock;
        boolean blockSouth = world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH)).func_177230_c() instanceof SideLinePaintBlock;
        boolean blockWest = world.func_180495_p(pos.func_177972_a(EnumFacing.WEST)).func_177230_c() instanceof SideLinePaintBlock;
        if (blockNorth) {
            stateNorth = world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH));
        }
        if (blockEast) {
            stateEast = world.func_180495_p(pos.func_177972_a(EnumFacing.EAST));
        }
        if (blockSouth) {
            stateSouth = world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH));
        }
        if (blockWest) {
            stateWest = world.func_180495_p(pos.func_177972_a(EnumFacing.WEST));
        }
        BlockPos posDown = pos.func_177972_a(EnumFacing.DOWN);
        BlockPos posUp = pos.func_177972_a(EnumFacing.UP);
        if (!blockNorth) {
            if (world.func_180495_p(posDown.func_177972_a(EnumFacing.NORTH)).func_177230_c() instanceof SideLinePaintBlock) {
                blockNorth = true;
                stateNorth = world.func_180495_p(posDown.func_177972_a(EnumFacing.NORTH));
            } else if (world.func_180495_p(posUp.func_177972_a(EnumFacing.NORTH)).func_177230_c() instanceof SideLinePaintBlock) {
                blockNorth = true;
                stateNorth = world.func_180495_p(posUp.func_177972_a(EnumFacing.NORTH));
            }
        }
        if (!blockEast) {
            if (world.func_180495_p(posDown.func_177972_a(EnumFacing.EAST)).func_177230_c() instanceof SideLinePaintBlock) {
                blockEast = true;
                stateEast = world.func_180495_p(posDown.func_177972_a(EnumFacing.EAST));
            } else if (world.func_180495_p(posUp.func_177972_a(EnumFacing.EAST)).func_177230_c() instanceof SideLinePaintBlock) {
                blockEast = true;
                stateEast = world.func_180495_p(posUp.func_177972_a(EnumFacing.EAST));
            }
        }
        if (!blockSouth) {
            if (world.func_180495_p(posDown.func_177972_a(EnumFacing.SOUTH)).func_177230_c() instanceof SideLinePaintBlock) {
                blockSouth = true;
                stateSouth = world.func_180495_p(posDown.func_177972_a(EnumFacing.SOUTH));
            } else if (world.func_180495_p(posUp.func_177972_a(EnumFacing.SOUTH)).func_177230_c() instanceof SideLinePaintBlock) {
                blockSouth = true;
                stateSouth = world.func_180495_p(posUp.func_177972_a(EnumFacing.SOUTH));
            }
        }
        if (!blockWest) {
            if (world.func_180495_p(posDown.func_177972_a(EnumFacing.WEST)).func_177230_c() instanceof SideLinePaintBlock) {
                blockWest = true;
                stateWest = world.func_180495_p(posDown.func_177972_a(EnumFacing.WEST));
            } else if (world.func_180495_p(posUp.func_177972_a(EnumFacing.WEST)).func_177230_c() instanceof SideLinePaintBlock) {
                blockWest = true;
                stateWest = world.func_180495_p(posUp.func_177972_a(EnumFacing.WEST));
            }
        }
        IBlockState stateUp = null;
        IBlockState stateDown = null;
        boolean blockUp = false;
        boolean blockLeft = false;
        boolean blockRight = false;
        boolean blockDown = false;
        if (this.func_176201_c(state) == 2) {
            blockUp = blockNorth;
            blockLeft = blockWest;
            blockRight = blockEast;
            blockDown = blockSouth;
            if (blockUp) {
                stateUp = stateNorth;
            }
            if (blockDown) {
                stateDown = stateSouth;
            }
        }
        if (this.func_176201_c(state) == 5) {
            blockUp = blockEast;
            blockLeft = blockNorth;
            blockRight = blockSouth;
            blockDown = blockWest;
            if (blockUp) {
                stateUp = stateEast;
            }
            if (blockDown) {
                stateDown = stateWest;
            }
        }
        if (this.func_176201_c(state) == 3) {
            blockUp = blockSouth;
            blockLeft = blockEast;
            blockRight = blockWest;
            blockDown = blockNorth;
            if (blockUp) {
                stateUp = stateSouth;
            }
            if (blockDown) {
                stateDown = stateNorth;
            }
        }
        if (this.func_176201_c(state) == 4) {
            blockUp = blockWest;
            blockLeft = blockSouth;
            blockRight = blockNorth;
            blockDown = blockEast;
            if (blockUp) {
                stateUp = stateWest;
            }
            if (blockDown) {
                stateDown = stateEast;
            }
        }
        boolean blockSide = false;
        int metaUp = -1;
        int metaDown = -1;
        if (blockUp && stateUp.func_177230_c() instanceof SideLinePaintBlock) {
            metaUp = stateUp.func_177230_c().func_176201_c(stateUp);
        }
        if (blockDown && stateDown.func_177230_c() instanceof SideLinePaintBlock) {
            metaDown = stateDown.func_177230_c().func_176201_c(stateDown);
        }
        if (leftSide) {
            if (blockRight && blockUp && (meta == 2 && metaUp != 4 || meta == 3 && metaUp != 5 || meta == 4 && metaUp != 3 || meta == 5 && metaUp != 2)) {
                return EnumConnectSideLine.EMPTY;
            }
            blockSide = blockLeft;
            blockRight = false;
        } else {
            if (blockLeft && blockUp && (meta == 2 && metaUp != 5 || meta == 3 && metaUp != 4 || meta == 4 && metaUp != 2 || meta == 5 && metaUp != 3)) {
                return EnumConnectSideLine.EMPTY;
            }
            blockSide = blockRight;
            blockLeft = false;
        }
        if (!blockUp && blockSide && !blockDown) {
            return EnumConnectSideLine.SIDE;
        }
        if (blockUp && blockSide && blockDown) {
            return EnumConnectSideLine.SIDE;
        }
        if (!blockUp && blockSide && blockDown) {
            return EnumConnectSideLine.SIDE;
        }
        if ((meta == 2 && metaUp == 4 || meta == 3 && metaUp == 5 || meta == 4 && metaUp == 3 || meta == 5 && metaUp == 2) && leftSide) {
            if (blockUp && !blockSide && !blockDown) {
                return EnumConnectSideLine.UP;
            }
            if (blockUp && !blockSide && blockDown) {
                return EnumConnectSideLine.UP;
            }
            if (blockUp && blockSide && !blockDown) {
                return EnumConnectSideLine.CORNER;
            }
        }
        if ((meta == 2 && metaUp == 5 || meta == 3 && metaUp == 4 || meta == 4 && metaUp == 2 || meta == 5 && metaUp == 3) && !leftSide) {
            if (blockUp && !blockSide && !blockDown) {
                return EnumConnectSideLine.UP;
            }
            if (blockUp && !blockSide && blockDown) {
                return EnumConnectSideLine.UP;
            }
            if (blockUp && blockSide && !blockDown) {
                return EnumConnectSideLine.CORNER;
            }
        }
        if ((meta == 2 && metaDown == 4 || meta == 3 && metaDown == 5 || meta == 4 && metaDown == 3 || meta == 5 && metaDown == 2) && leftSide && !blockUp && !blockSide && blockDown) {
            return EnumConnectSideLine.DOWN;
        }
        if ((meta == 2 && metaDown == 5 || meta == 3 && metaDown == 4 || meta == 4 && metaDown == 2 || meta == 5 && metaDown == 3) && !leftSide && !blockUp && !blockSide && blockDown) {
            return EnumConnectSideLine.DOWN;
        }
        if (blockSide) {
            return EnumConnectSideLine.SIDE;
        }
        return EnumConnectSideLine.NONE;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(CONNECT_LEFT, (Comparable)((Object)this.canLineConnectTo(worldIn, pos, true))).func_177226_a(CONNECT_RIGHT, (Comparable)((Object)this.canLineConnectTo(worldIn, pos, false)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

