/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.crusher;

import com.silvaniastudios.roads.blocks.tileentities.RoadTEBlock;
import com.silvaniastudios.roads.blocks.tileentities.RoadTileEntity;
import com.silvaniastudios.roads.blocks.tileentities.crusher.CrusherElectricEntity;
import com.silvaniastudios.roads.blocks.tileentities.crusher.CrusherEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CrusherBlock
extends RoadTEBlock {
    public static final PropertyBool FURNACE_ACTIVE = PropertyBool.func_177716_a((String)"furnace_active");

    public CrusherBlock(String name, boolean electric) {
        super(name, electric, 5);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ROTATION, (Comparable)((Object)RoadTEBlock.EnumRotation.north)).func_177226_a((IProperty)FURNACE_ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        if (this.electric) {
            return new CrusherElectricEntity();
        }
        return new CrusherEntity();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"roads.gui.crusher.tooltip_1", (Object[])new Object[0]));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION, FURNACE_ACTIVE, BASE_PLATE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof RoadTileEntity) {
            RoadTileEntity tileEntity = (RoadTileEntity)te;
            if (tileEntity.fuel_remaining > 0) {
                return state.func_177226_a((IProperty)FURNACE_ACTIVE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BASE_PLATE, (Comparable)Boolean.valueOf(this.hasBasePlate(world, pos)));
            }
            return state.func_177226_a((IProperty)FURNACE_ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BASE_PLATE, (Comparable)Boolean.valueOf(this.hasBasePlate(world, pos)));
        }
        return state;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.90625, 0.875);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_185496_a(state, world, pos);
    }
}

