/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.paintfiller;

import com.silvaniastudios.roads.blocks.tileentities.RoadTEBlock;
import com.silvaniastudios.roads.blocks.tileentities.paintfiller.PaintFillerElectricEntity;
import com.silvaniastudios.roads.blocks.tileentities.paintfiller.PaintFillerEntity;
import com.silvaniastudios.roads.items.PaintGun;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PaintFillerBlock
extends RoadTEBlock {
    protected String name;
    public static final PropertyBool GUN_LOADED = PropertyBool.func_177716_a((String)"gun_loaded");

    public PaintFillerBlock(String name, boolean electric) {
        super(name, electric, 1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)GUN_LOADED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)RoadTEBlock.EnumRotation.north)).func_177226_a((IProperty)FURNACE_ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"roads.gui.paint_filler.tooltip_1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"roads.gui.paint_filler.tooltip_2", (Object[])new Object[0]));
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        if (this.electric) {
            return new PaintFillerElectricEntity();
        }
        return new PaintFillerEntity();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        boolean hasGun = false;
        if (tileEntity instanceof PaintFillerEntity) {
            PaintFillerEntity te = (PaintFillerEntity)tileEntity;
            hasGun = this.hasGun(te);
        }
        return state.func_177226_a((IProperty)GUN_LOADED, (Comparable)Boolean.valueOf(hasGun)).func_177226_a((IProperty)FURNACE_ACTIVE, (Comparable)Boolean.valueOf(this.isFurnaceEnabled(state, world, pos))).func_177226_a((IProperty)BASE_PLATE, (Comparable)Boolean.valueOf(this.hasBasePlate(world, pos)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        int meta = this.func_176201_c(state);
        if (meta == 0) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.9375, 1.0, 0.9375);
        }
        if (meta == 1) {
            return new AxisAlignedBB(0.0625, 0.0, 0.0, 1.0, 1.0, 0.9375);
        }
        if (meta == 2) {
            return new AxisAlignedBB(0.0625, 0.0, 0.0625, 1.0, 1.0, 1.0);
        }
        if (meta == 3) {
            return new AxisAlignedBB(0.0, 0.0, 0.0625, 0.9375, 1.0, 1.0);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_185496_a(state, world, pos);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{GUN_LOADED, ROTATION, FURNACE_ACTIVE, BASE_PLATE});
    }

    public boolean hasGun(PaintFillerEntity tileEntity) {
        if (tileEntity.inventory.getStackInSlot(1).func_77973_b() instanceof PaintGun) {
            return true;
        }
        return tileEntity.has_gun;
    }
}

