/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.paintfiller.hopper;

import com.google.common.collect.ImmutableList;
import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.tileentities.RoadTEBlock;
import com.silvaniastudios.roads.blocks.tileentities.paintfiller.PaintFillerBlock;
import com.silvaniastudios.roads.blocks.tileentities.paintfiller.hopper.PaintFillerHopperEntity;
import com.silvaniastudios.roads.items.ItemWrench;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PaintFillerHopperBlock
extends Block {
    protected String name;
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyEnum<RoadTEBlock.EnumRotation> ROTATION = PropertyEnum.func_177709_a((String)"rotation", RoadTEBlock.EnumRotation.class);
    public static final PropertyBool IS_OUTPUT = PropertyBool.func_177716_a((String)"is_output");

    public PaintFillerHopperBlock(String name) {
        super(Material.field_151573_f);
        this.name = name;
        this.func_149663_c("furenikusroads." + name);
        this.setRegistryName(name);
        this.func_149647_a(FurenikusRoads.tab_tools);
        this.func_149711_c(2.5f);
        this.setHarvestLevel("pickaxe", 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"roads.gui.paint_filler_hopper.tooltip_1", (Object[])new Object[0]));
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new PaintFillerHopperEntity();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_184586_b(hand).func_77973_b() instanceof ItemWrench) {
            ItemWrench wrench = (ItemWrench)player.func_184586_b(hand).func_77973_b();
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof PaintFillerHopperEntity) {
                PaintFillerHopperEntity te = (PaintFillerHopperEntity)tileEntity;
                if (wrench.getMode(player.func_184586_b(hand)) == 1) {
                    te.toggleOutputMode();
                } else {
                    te.updateSide(facing);
                }
            }
        }
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a(ROTATION, (Comparable)((Object)this.getRotation(world, pos))).func_177226_a((IProperty)IS_OUTPUT, (Comparable)Boolean.valueOf(this.getOutput(world, pos))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.getIO(world, pos, EnumFacing.UP))).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.getIO(world, pos, EnumFacing.NORTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.getIO(world, pos, EnumFacing.EAST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.getIO(world, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.getIO(world, pos, EnumFacing.WEST)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, NORTH, EAST, SOUTH, WEST, ROTATION, IS_OUTPUT});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public boolean getOutput(IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof PaintFillerHopperEntity) {
            PaintFillerHopperEntity te = (PaintFillerHopperEntity)tileEntity;
            return te.getOutput();
        }
        return true;
    }

    public boolean getIO(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof PaintFillerHopperEntity) {
            PaintFillerHopperEntity te = (PaintFillerHopperEntity)tileEntity;
            return te.getIOFromSide(dir) != EnumIO.none;
        }
        return false;
    }

    public RoadTEBlock.EnumRotation getRotation(IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c() instanceof PaintFillerBlock) {
            return (RoadTEBlock.EnumRotation)((Object)world.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177229_b(RoadTEBlock.ROTATION));
        }
        return RoadTEBlock.EnumRotation.north;
    }

    public boolean isElectric(IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c() instanceof PaintFillerBlock) {
            PaintFillerBlock block = (PaintFillerBlock)world.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c();
            return block.isElectric();
        }
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean north = this.getIO(world, pos, EnumFacing.NORTH);
        boolean east = this.getIO(world, pos, EnumFacing.EAST);
        boolean south = this.getIO(world, pos, EnumFacing.SOUTH);
        boolean west = this.getIO(world, pos, EnumFacing.WEST);
        boolean up = this.getIO(world, pos, EnumFacing.UP);
        double n = north ? 0.0 : 0.1875;
        double e = east ? 1.0 : 0.8125;
        double s = south ? 1.0 : 0.8125;
        double w = west ? 0.0 : 0.1875;
        double u = up ? 1.0 : 0.75;
        return new AxisAlignedBB(w, 0.0, n, e, u, s);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_185496_a(state, world, pos);
    }

    public void registerItemModel(Item itemBlock) {
        FurenikusRoads.proxy.registerItemRenderer(itemBlock, 0, this.name);
    }

    public Item createItemBlock() {
        return (Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName());
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        DefaultStateMapper b = new DefaultStateMapper();
        BlockStateContainer bsc = this.func_176194_O();
        ImmutableList values = bsc.func_177619_a();
        for (IBlockState state : values) {
            ModelResourceLocation mrl = new ModelResourceLocation(state.func_177230_c().getRegistryName(), b.func_178131_a((Map)state.func_177228_b()));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)state.func_177230_c()), (int)this.func_176201_c(state), (ModelResourceLocation)mrl);
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public static enum EnumIO implements IStringSerializable
    {
        none("none"),
        white("white"),
        yellow("yellow"),
        red("red"),
        item("item");

        private final String name;

        private EnumIO(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static EnumIO byId(int byId) {
            if (byId == 1) {
                return white;
            }
            if (byId == 2) {
                return yellow;
            }
            if (byId == 3) {
                return red;
            }
            if (byId == 4) {
                return item;
            }
            return none;
        }
    }
}

