/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.tarmaccutter;

import com.silvaniastudios.roads.blocks.tileentities.RoadTEBlock;
import com.silvaniastudios.roads.blocks.tileentities.RoadTileEntity;
import com.silvaniastudios.roads.blocks.tileentities.tarmaccutter.TarmacCutterElectricEntity;
import com.silvaniastudios.roads.blocks.tileentities.tarmaccutter.TarmacCutterEntity;
import com.silvaniastudios.roads.items.TarmacCutterBlade;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TarmacCutterBlock
extends RoadTEBlock {
    public static final PropertyEnum<EnumBladeType> BLADE = PropertyEnum.func_177709_a((String)"blade", EnumBladeType.class);

    public TarmacCutterBlock(String name, boolean electric) {
        super(name, electric, 4);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ROTATION, (Comparable)((Object)RoadTEBlock.EnumRotation.north)).func_177226_a(BLADE, (Comparable)((Object)EnumBladeType.none)).func_177226_a((IProperty)FURNACE_ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        if (this.electric) {
            return new TarmacCutterElectricEntity();
        }
        return new TarmacCutterEntity();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"roads.gui.tarmac_cutter.tooltip_1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"roads.gui.tarmac_cutter.tooltip_2", (Object[])new Object[0]));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION, BLADE, FURNACE_ACTIVE, BASE_PLATE});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof RoadTileEntity) {
            RoadTileEntity tileEntity = (RoadTileEntity)te;
            EnumBladeType bladeType = this.getBladeType(world, pos);
            if (tileEntity.fuel_remaining > 0) {
                return state.func_177226_a((IProperty)FURNACE_ACTIVE, (Comparable)Boolean.valueOf(true)).func_177226_a(BLADE, (Comparable)((Object)bladeType)).func_177226_a((IProperty)BASE_PLATE, (Comparable)Boolean.valueOf(this.hasBasePlate(world, pos)));
            }
            return state.func_177226_a((IProperty)FURNACE_ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a(BLADE, (Comparable)((Object)bladeType)).func_177226_a((IProperty)BASE_PLATE, (Comparable)Boolean.valueOf(this.hasBasePlate(world, pos)));
        }
        return super.func_176221_a(state, world, pos);
    }

    public EnumBladeType getBladeType(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TarmacCutterEntity) {
            TarmacCutterEntity te = (TarmacCutterEntity)tile;
            ItemStack item = te.inventory.getStackInSlot(1);
            if (item.func_77973_b() instanceof TarmacCutterBlade) {
                TarmacCutterBlade blade = (TarmacCutterBlade)item.func_77973_b();
                return EnumBladeType.byName(blade.getType());
            }
        }
        return EnumBladeType.none;
    }

    public static enum EnumBladeType implements IStringSerializable
    {
        none("none"),
        iron("iron"),
        gold("gold"),
        diamond("diamond");

        private final String name;
        private static final EnumBladeType[] META_LOOKUP;

        private EnumBladeType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static EnumBladeType byName(String name) {
            if (name != null) {
                for (int i = 0; i < META_LOOKUP.length; ++i) {
                    if (EnumBladeType.byMeta(i) == null || !EnumBladeType.byMeta((int)i).name.equalsIgnoreCase(name)) continue;
                    return EnumBladeType.byMeta(i);
                }
            }
            return none;
        }

        public static EnumBladeType byMeta(int meta) {
            if (meta == 0) {
                return none;
            }
            if (meta == 1) {
                return iron;
            }
            if (meta == 2) {
                return gold;
            }
            return diamond;
        }

        static {
            META_LOOKUP = new EnumBladeType[EnumBladeType.values().length];
        }
    }
}

