/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.gui;

import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.tileentities.fabricator.FabricatorContainer;
import com.silvaniastudios.roads.blocks.tileentities.fabricator.FabricatorElectricEntity;
import com.silvaniastudios.roads.blocks.tileentities.fabricator.FabricatorEntity;
import com.silvaniastudios.roads.blocks.tileentities.recipes.FabricatorRecipes;
import com.silvaniastudios.roads.blocks.tileentities.recipes.RecipeRegistry;
import com.silvaniastudios.roads.client.gui.GuiFabricatorSelector;
import com.silvaniastudios.roads.client.gui.GuiHiddenButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiFabricator
extends GuiContainer {
    private static final ResourceLocation guiTextures = new ResourceLocation("furenikusroads:textures/gui/fabricator.png");
    private FabricatorEntity tileEntity;
    private boolean electric;
    GuiHiddenButton openSelector;
    FabricatorRecipes recipe;

    public GuiFabricator(FabricatorEntity tileEntity, FabricatorContainer container, boolean electric) {
        super((Container)container);
        this.field_146999_f = 176;
        this.field_147000_g = 152;
        this.tileEntity = tileEntity;
        this.electric = electric;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiLeft = (this.field_146294_l - this.field_146999_f) / 2;
        int guiTop = (this.field_146295_m - this.field_147000_g) / 2;
        this.openSelector = new GuiHiddenButton(1, guiLeft + 78, guiTop + 20, 34, 34);
        this.field_146292_n.add(this.openSelector);
        this.setRecipe();
    }

    private void setRecipe() {
        for (int i = 0; i < RecipeRegistry.fabricatorRecipes.size(); ++i) {
            FabricatorRecipes recipe = RecipeRegistry.fabricatorRecipes.get(i);
            if (recipe.getId() != this.tileEntity.recipeId) continue;
            this.recipe = recipe;
            break;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        if (this.recipe.getId() != this.tileEntity.recipeId) {
            this.setRecipe();
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int left = (this.field_146294_l - this.field_146999_f) / 2;
        int top = (this.field_146295_m - this.field_147000_g) / 2;
        this.drawTooltip(2, left, top, mouseX, mouseY);
        if (this.electric) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"roads.gui.electric_fabricator.name", (Object[])new Object[0]), 6, 6, 0x404040);
        } else {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"roads.gui.fabricator.name", (Object[])new Object[0]), 6, 6, 0x404040);
        }
    }

    private void drawTooltip(int col, int left, int top, int mouseX, int mouseY) {
        if (this.electric) {
            FabricatorElectricEntity fee = (FabricatorElectricEntity)this.tileEntity;
            if (mouseX >= left + 155 && mouseX <= left + 169 && mouseY >= top + 7 && mouseY <= top + 49) {
                this.func_146279_a(fee.energy.getEnergyStored() + "/" + fee.energy.getMaxEnergyStored(), mouseX - left, mouseY - top + 15);
            }
        } else if (mouseX >= left + 153 && mouseX <= left + 167 && mouseY >= top + 15 && mouseY <= top + 29) {
            this.func_146279_a(this.tileEntity.fuel_remaining + "/" + this.tileEntity.last_fuel_cap, mouseX - left, mouseY - top + 15);
        }
        if (this.tileEntity.inventory.getStackInSlot(0).func_190916_E() < 1 && this.recipe != null && mouseX >= left + 7 && mouseX <= left + 24 && mouseY >= top + 19 && mouseY <= top + 36 && this.recipe.getInput1() != ItemStack.field_190927_a) {
            this.func_146279_a(I18n.func_135052_a((String)"roads.gui.fabricator.requirement", (Object[])new Object[0]) + this.recipe.getInput1().func_190916_E() + "x " + this.recipe.getInput1().func_82833_r(), mouseX - left, mouseY - top + 15);
        }
        if (this.tileEntity.inventory.getStackInSlot(1).func_190916_E() < 1 && this.recipe != null && mouseX >= left + 25 && mouseX <= left + 42 && mouseY >= top + 19 && mouseY <= top + 36 && this.recipe.getInput2() != ItemStack.field_190927_a) {
            this.func_146279_a(I18n.func_135052_a((String)"roads.gui.fabricator.requirement", (Object[])new Object[0]) + this.recipe.getInput2().func_190916_E() + "x " + this.recipe.getInput2().func_82833_r(), mouseX - left, mouseY - top + 15);
        }
        if (this.tileEntity.inventory.getStackInSlot(2).func_190916_E() < 1 && this.recipe != null && mouseX >= left + 43 && mouseX <= left + 60 && mouseY >= top + 19 && mouseY <= top + 36 && this.recipe.getInput3() != ItemStack.field_190927_a) {
            this.func_146279_a(I18n.func_135052_a((String)"roads.gui.fabricator.requirement", (Object[])new Object[0]) + this.recipe.getInput3().func_190916_E() + "x " + this.recipe.getInput3().func_82833_r(), mouseX - left, mouseY - top + 15);
        }
        if (this.tileEntity.inventory.getStackInSlot(3).func_190916_E() < 1 && this.recipe != null && mouseX >= left + 7 && mouseX <= left + 24 && mouseY >= top + 37 && mouseY <= top + 54 && this.recipe.getInput4() != ItemStack.field_190927_a) {
            this.func_146279_a(I18n.func_135052_a((String)"roads.gui.fabricator.requirement", (Object[])new Object[0]) + this.recipe.getInput4().func_190916_E() + "x " + this.recipe.getInput4().func_82833_r(), mouseX - left, mouseY - top + 15);
        }
        if (this.tileEntity.inventory.getStackInSlot(4).func_190916_E() < 1 && this.recipe != null && mouseX >= left + 25 && mouseX <= left + 42 && mouseY >= top + 37 && mouseY <= top + 54 && this.recipe.getInput5() != ItemStack.field_190927_a) {
            this.func_146279_a(I18n.func_135052_a((String)"roads.gui.fabricator.requirement", (Object[])new Object[0]) + this.recipe.getInput5().func_190916_E() + "x " + this.recipe.getInput5().func_82833_r(), mouseX - left, mouseY - top + 15);
        }
        if (this.tileEntity.inventory.getStackInSlot(5).func_190916_E() < 1 && this.recipe != null && mouseX >= left + 43 && mouseX <= left + 60 && mouseY >= top + 37 && mouseY <= top + 54 && this.recipe.getInput6() != ItemStack.field_190927_a) {
            this.func_146279_a(I18n.func_135052_a((String)"roads.gui.fabricator.requirement", (Object[])new Object[0]) + this.recipe.getInput6().func_190916_E() + "x " + this.recipe.getInput6().func_82833_r(), mouseX - left, mouseY - top + 15);
        }
        if (mouseX >= left + 79 && mouseX <= left + 111 && mouseY >= top + 21 && mouseY <= top + 53) {
            this.func_146279_a(I18n.func_135052_a((String)"roads.gui.fabricator.recipe_select", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTextures);
        int left = (this.field_146294_l - this.field_146999_f) / 2;
        int top = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(left, top, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.electric) {
            this.func_73729_b(left + this.field_146999_f - 25, top, 176, 0, 25, this.field_147000_g);
        }
        this.drawFuel(left, top);
        this.drawProgress(left, top);
        if (this.recipe != null) {
            this.drawItemStack(this.recipe.getOutput(), left + 79, top + 21);
            if (this.recipe.getInput1() != ItemStack.field_190927_a && this.tileEntity.inventory.getStackInSlot(0).func_190916_E() < 1) {
                this.drawIngredientStack(this.recipe.getInput1(), left + 16, top + 28);
            }
            if (this.recipe.getInput2() != ItemStack.field_190927_a && this.tileEntity.inventory.getStackInSlot(1).func_190916_E() < 1) {
                this.drawIngredientStack(this.recipe.getInput2(), left + 34, top + 28);
            }
            if (this.recipe.getInput3() != ItemStack.field_190927_a && this.tileEntity.inventory.getStackInSlot(2).func_190916_E() < 1) {
                this.drawIngredientStack(this.recipe.getInput3(), left + 52, top + 28);
            }
            if (this.recipe.getInput4() != ItemStack.field_190927_a && this.tileEntity.inventory.getStackInSlot(3).func_190916_E() < 1) {
                this.drawIngredientStack(this.recipe.getInput4(), left + 16, top + 46);
            }
            if (this.recipe.getInput5() != ItemStack.field_190927_a && this.tileEntity.inventory.getStackInSlot(4).func_190916_E() < 1) {
                this.drawIngredientStack(this.recipe.getInput5(), left + 34, top + 46);
            }
            if (this.recipe.getInput6() != ItemStack.field_190927_a && this.tileEntity.inventory.getStackInSlot(5).func_190916_E() < 1) {
                this.drawIngredientStack(this.recipe.getInput6(), left + 52, top + 46);
            }
        }
    }

    private void drawFuel(int left, int top) {
        if (this.electric) {
            FabricatorElectricEntity fee = (FabricatorElectricEntity)this.tileEntity;
            int p = this.getPercentage(fee.energy.getEnergyStored(), fee.energy.getMaxEnergyStored());
            int x = Math.round((float)p / 2.5f);
            if (p == 100) {
                x = 42;
            }
            this.func_73729_b(left + 155, top + 7 + (42 - x), 242, 42 - x, 14, x);
        } else {
            int p = this.getPercentage(this.tileEntity.fuel_remaining, this.tileEntity.last_fuel_cap);
            int x = Math.round((float)p / 7.0f);
            this.func_73729_b(left + 153, top + 15 + (14 - x), 229, 14 - x, 13, x);
        }
    }

    private void drawProgress(int left, int top) {
        int p = this.getPercentage(this.tileEntity.timerCount, this.electric ? RoadsConfig.machine.electricFabricatorTickRate : RoadsConfig.machine.fabricatorTickRate);
        int x = Math.round((float)p * 1.6f);
        this.func_73729_b(left + 8, top + 60, 0, 252, x, 4);
    }

    private int getPercentage(int num, int max) {
        float x = (float)num / (float)max;
        int y = Math.round(x * 100.0f);
        if (y > 100) {
            return 100;
        }
        return y;
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.openSelector) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiFabricatorSelector(this.tileEntity));
        }
    }

    private void drawItemStack(ItemStack stack, int x, int y) {
        RenderHelper.func_74518_a();
        RenderHelper.func_74520_c();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)2.0);
        Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, x / 2, y / 2);
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)3.0f);
        this.field_146289_q.func_78276_b("" + stack.func_190916_E(), x + 26, y + 24, 0xFFFFFF);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-35.0f);
        RenderHelper.func_74519_b();
    }

    private void drawIngredientStack(ItemStack stack, int x, int y) {
        RenderHelper.func_74518_a();
        RenderHelper.func_74520_c();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        this.field_146289_q.func_78276_b(stack.func_190916_E() + "x", (x - 19 + this.field_146289_q.func_78256_a(stack.func_190916_E() + "x")) * 2, (y + 3) * 2, 0xFFFFFF);
        Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, x * 2, y * 2);
        GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)2.0);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-32.0f);
        RenderHelper.func_74519_b();
    }
}

