/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.gui;

import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.FRBlocks;
import com.silvaniastudios.roads.blocks.tileentities.distiller.TarDistillerBlock;
import com.silvaniastudios.roads.blocks.tileentities.roadfactory.RoadFactoryBlock;
import com.silvaniastudios.roads.blocks.tileentities.roadfactory.RoadFactoryContainer;
import com.silvaniastudios.roads.blocks.tileentities.roadfactory.RoadFactoryElectricEntity;
import com.silvaniastudios.roads.blocks.tileentities.roadfactory.RoadFactoryEntity;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidTank;

public class GuiRoadFactory
extends GuiContainer {
    private static final ResourceLocation guiTextures = new ResourceLocation("furenikusroads:textures/gui/road_factory.png");
    private RoadFactoryEntity tileEntity;
    private boolean electric;

    public GuiRoadFactory(RoadFactoryEntity tileEntity, RoadFactoryContainer container, boolean electric) {
        super((Container)container);
        this.field_146999_f = 176;
        this.field_147000_g = 206;
        this.tileEntity = tileEntity;
        this.electric = electric;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int left = (this.field_146294_l - this.field_146999_f) / 2;
        int top = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"roads.gui.road_factory.link", (Object[])new Object[0]), 116, 96, 0x404040);
        this.drawTooltip(2, left, top, mouseX, mouseY);
        if (this.electric) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"roads.gui.electric_road_factory.name", (Object[])new Object[0]), 32, 6, 0x404040);
        } else {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"roads.gui.road_factory.name", (Object[])new Object[0]), 32, 6, 0x404040);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTextures);
        int left = (this.field_146294_l - this.field_146999_f) / 2;
        int top = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(left, top, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.electric) {
            this.func_73729_b(left + this.field_146999_f - 25, top, 176, 0, 25, 206);
        }
        if (this.tileEntity.inventory.getSlots() < 12) {
            this.func_73729_b(left + 81, top + 42, 238, 42, 18, 18);
        }
        this.drawFluid(left + 8, top + 8, this.tileEntity.tarFluid);
        this.drawFuel(left, top);
        this.drawProgress(left, top);
        if (this.distillerFound()) {
            this.func_73729_b(left + 157, top + 95, 232, 14, 10, 10);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    private void drawFuel(int left, int top) {
        if (this.electric) {
            RoadFactoryElectricEntity rfee = (RoadFactoryElectricEntity)this.tileEntity;
            int p = this.getPercentage(rfee.energy.getEnergyStored(), rfee.energy.getMaxEnergyStored());
            int x = Math.round((float)p / 2.5f);
            if (p == 100) {
                x = 42;
            }
            this.func_73729_b(left + 153, top + 18 + (42 - x), 242, 42 - x, 14, x);
        } else {
            int p = this.getPercentage(this.tileEntity.fuel_remaining, this.tileEntity.last_fuel_cap);
            int x = Math.round((float)p / 7.0f);
            this.func_73729_b(left + 153, top + 23 + (14 - x), 228, 14 - x, 14, x);
        }
    }

    private void drawProgress(int left, int top) {
        int p = this.getPercentage(this.tileEntity.timerCount, RoadsConfig.machine.roadFactoryTickRate);
        int x = Math.round((float)p * 1.6f);
        this.func_73729_b(left + 8, top + 114, 0, 252, x, 4);
    }

    private void drawTooltip(int col, int left, int top, int mouseX, int mouseY) {
        if (mouseX >= left + 8 && mouseX <= left + 28 && mouseY >= top + 8 && mouseY <= top + 108) {
            this.func_146279_a(this.tileEntity.tarFluid.getFluidAmount() + "/" + 320000, mouseX - left, mouseY - top + 15);
        }
        if (this.electric) {
            RoadFactoryElectricEntity rfee = (RoadFactoryElectricEntity)this.tileEntity;
            if (mouseX >= left + 153 && mouseX <= left + 167 && mouseY >= top + 18 && mouseY <= top + 60) {
                this.func_146279_a(rfee.energy.getEnergyStored() + "/" + rfee.energy.getMaxEnergyStored(), mouseX - left, mouseY - top + 15);
            }
        } else if (mouseX >= left + 153 && mouseX <= left + 167 && mouseY >= top + 23 && mouseY <= top + 37) {
            this.func_146279_a(this.tileEntity.fuel_remaining + "/" + this.tileEntity.last_fuel_cap, mouseX - left, mouseY - top + 15);
        }
        if (this.tileEntity.inventory.getSlots() < 12) {
            List<String> errorList = Arrays.asList("An update is available for this machine, and is required to use this slot.", "Please break and re-place the machine in order to use the Modifier slot.");
            if (mouseX >= left + 82 && mouseX <= left + 98 && mouseY >= top + 43 && mouseY <= top + 59) {
                this.func_146283_a(errorList, mouseX - left, mouseY - top + 15);
            }
        }
        if (RoadsConfig.general.guiGuide) {
            boolean showOutput;
            String a = TextFormatting.RESET + " -> " + TextFormatting.GREEN;
            List<String> inputList = Arrays.asList(I18n.func_135052_a((String)"roads.gui.inputSlot", (Object[])new Object[0]), "", TextFormatting.UNDERLINE + I18n.func_135052_a((String)"roads.gui.valid", (Object[])new Object[0]), TextFormatting.RED + I18n.func_135052_a((String)"roads.gui.road_factory.tar_required", (Object[])new Object[0]), TextFormatting.AQUA + new ItemStack((Block)FRBlocks.generic_blocks, 1, 0).func_82833_r() + a + FRBlocks.road_block_standard.func_149732_F(), TextFormatting.AQUA + new ItemStack(Blocks.field_150348_b, 1, 0).func_82833_r() + a + FRBlocks.road_block_stone.func_149732_F(), TextFormatting.AQUA + new ItemStack(Blocks.field_150348_b, 1, 1).func_82833_r() + a + FRBlocks.road_block_pale.func_149732_F(), TextFormatting.AQUA + new ItemStack(Blocks.field_150348_b, 1, 3).func_82833_r() + a + FRBlocks.road_block_light.func_149732_F(), TextFormatting.AQUA + new ItemStack(Blocks.field_150348_b, 1, 5).func_82833_r() + a + FRBlocks.road_block_dark.func_149732_F(), TextFormatting.AQUA + new ItemStack(Blocks.field_150348_b, 1, 6).func_82833_r() + a + FRBlocks.road_block_fine.func_149732_F(), TextFormatting.AQUA + Blocks.field_150349_c.func_149732_F() + a + FRBlocks.road_block_grass.func_149732_F(), TextFormatting.AQUA + Blocks.field_150346_d.func_149732_F() + a + FRBlocks.road_block_dirt.func_149732_F(), TextFormatting.AQUA + Blocks.field_150351_n.func_149732_F() + a + FRBlocks.road_block_gravel.func_149732_F(), TextFormatting.AQUA + Blocks.field_150354_m.func_149732_F() + a + FRBlocks.road_block_sand.func_149732_F());
            List<String> modifierList = Arrays.asList(I18n.func_135052_a((String)"roads.gui.road_factory.modifierSlot", (Object[])new Object[0]), "", I18n.func_135052_a((String)"roads.gui.road_factory.modifierSlot.tooltip_1", (Object[])new Object[0]), I18n.func_135052_a((String)"roads.gui.road_factory.modifierSlot.tooltip_2", (Object[])new Object[0]), TextFormatting.AQUA + I18n.func_135052_a((String)"roads.gui.road_factory.modifierSlot.red_dye", (Object[])new Object[0]) + a + FRBlocks.road_block_red.func_149732_F(), TextFormatting.AQUA + I18n.func_135052_a((String)"roads.gui.road_factory.modifierSlot.blue_dye", (Object[])new Object[0]) + a + FRBlocks.road_block_blue.func_149732_F(), TextFormatting.AQUA + I18n.func_135052_a((String)"roads.gui.road_factory.modifierSlot.yellow_dye", (Object[])new Object[0]) + a + FRBlocks.road_block_yellow.func_149732_F(), TextFormatting.AQUA + I18n.func_135052_a((String)"roads.gui.road_factory.modifierSlot.green_dye", (Object[])new Object[0]) + a + FRBlocks.road_block_green.func_149732_F(), TextFormatting.AQUA + I18n.func_135052_a((String)"roads.gui.road_factory.modifierSlot.white_dye", (Object[])new Object[0]) + a + FRBlocks.road_block_white.func_149732_F());
            boolean showInput = this.tileEntity.inventory.getStackInSlot(0).func_190916_E() + this.tileEntity.inventory.getStackInSlot(1).func_190916_E() + this.tileEntity.inventory.getStackInSlot(2).func_190916_E() + this.tileEntity.inventory.getStackInSlot(3).func_190916_E() == 0;
            boolean bl = showOutput = this.tileEntity.inventory.getStackInSlot(4).func_190916_E() + this.tileEntity.inventory.getStackInSlot(5).func_190916_E() + this.tileEntity.inventory.getStackInSlot(6).func_190916_E() + this.tileEntity.inventory.getStackInSlot(7).func_190916_E() == 0;
            if (mouseX >= left + 34 && mouseX <= left + 73 && mouseY >= top + 20 && mouseY <= top + 59 && showInput) {
                this.func_146283_a(inputList, mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 107 && mouseX <= left + 146 && mouseY >= top + 20 && mouseY <= top + 59 && showOutput) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.outputSlot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 34 && mouseX <= left + 50 && mouseY >= top + 70 && mouseY <= top + 86 && this.tileEntity.inventory.getStackInSlot(9).func_190916_E() == 0) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.tarInputSlot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 34 && mouseX <= left + 50 && mouseY >= top + 92 && mouseY <= top + 108 && this.tileEntity.inventory.getStackInSlot(10).func_190916_E() == 0) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.bucketOutputSlot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 152 && mouseX <= left + 168 && mouseY >= top + 43 && mouseY <= top + 59 && !this.electric && this.tileEntity.inventory.getStackInSlot(8).func_190916_E() == 0) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.fuelSlot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 82 && mouseX <= left + 98 && mouseY >= top + 43 && mouseY <= top + 59 && this.tileEntity.inventory.getSlots() >= 12 && this.tileEntity.inventory.getStackInSlot(11).func_190916_E() == 0) {
                this.func_146283_a(modifierList, mouseX - left, mouseY - top + 15);
            }
            if (this.distillerFound()) {
                if (mouseX >= left + 114 && mouseX <= left + 169 && mouseY >= top + 93 && mouseY <= top + 107) {
                    this.func_146279_a(TextFormatting.GREEN + I18n.func_135052_a((String)"roads.gui.road_factory.connect_pass", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
                }
            } else {
                List<String> error = Arrays.asList(TextFormatting.RED + I18n.func_135052_a((String)"roads.gui.road_factory.connect_failed_1", (Object[])new Object[0]), TextFormatting.RED + I18n.func_135052_a((String)"roads.gui.road_factory.connect_failed_2", (Object[])new Object[0]), TextFormatting.RED + I18n.func_135052_a((String)"roads.gui.road_factory.connect_failed_3", (Object[])new Object[0]));
                if (mouseX >= left + 114 && mouseX <= left + 169 && mouseY >= top + 93 && mouseY <= top + 107) {
                    this.func_146283_a(error, mouseX - left, mouseY - top + 15);
                }
            }
        }
    }

    private void drawFluid(int left, int top, FluidTank fluid) {
        if (fluid.getFluidAmount() > 0) {
            int fillPercent = this.getPercentage(fluid.getFluidAmount(), 320000);
            this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            TextureAtlasSprite texture = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFluid().getFluid().getStill(fluid.getFluid()).toString());
            for (int i = 0; i < 6; ++i) {
                this.drawFluidQuad(left, top + i * 16, 16, 16, texture);
                this.drawFluidQuad(left + 16, top + i * 16, 4, 16, texture);
            }
            this.drawFluidQuad(left, top + 96, 16, 4, texture);
            this.drawFluidQuad(left + 16, top + 96, 4, 4, texture);
            this.field_146297_k.func_110434_K().func_110577_a(guiTextures);
            this.func_73729_b(left, top, 8, 8, 20, 100 - fillPercent);
        }
        this.func_73729_b(left, top, 236, 156, 20, 100);
    }

    private void drawFluidQuad(int x, int y, int width, int height, TextureAtlasSprite texture) {
        float minU = texture.func_94214_a(0.0);
        float minV = texture.func_94207_b(0.0);
        float maxU = texture.func_94214_a((double)width);
        float maxV = texture.func_94207_b((double)height);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)x, (double)(y + height), (double)this.field_73735_i).func_187315_a((double)minU, (double)maxV).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)y, (double)this.field_73735_i).func_187315_a((double)maxU, (double)minV).func_181675_d();
        worldrenderer.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a((double)minU, (double)minV).func_181675_d();
        tessellator.func_78381_a();
    }

    private int getPercentage(int num, int max) {
        float x = (float)num / (float)max;
        int y = Math.round(x * 100.0f);
        if (y > 100) {
            return 100;
        }
        return y;
    }

    private boolean distillerFound() {
        IBlockState state = this.tileEntity.getState();
        RoadFactoryBlock block = (RoadFactoryBlock)this.tileEntity.func_145838_q();
        EnumFacing left = EnumFacing.WEST;
        if (block.func_176201_c(state) == 1) {
            left = EnumFacing.NORTH;
        }
        if (block.func_176201_c(state) == 2) {
            left = EnumFacing.EAST;
        }
        if (block.func_176201_c(state) == 3) {
            left = EnumFacing.SOUTH;
        }
        return this.field_146297_k.field_71441_e.func_180495_p(this.tileEntity.func_174877_v().func_177972_a(left)).func_177230_c() instanceof TarDistillerBlock;
    }
}

