/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.model;

import com.silvaniastudios.roads.blocks.tileentities.paintfiller.PaintFillerEntity;
import com.silvaniastudios.roads.client.model.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraftforge.client.model.animation.FastTESR;
import net.minecraftforge.fluids.FluidStack;

public class PaintFillerRenderer
extends FastTESR<PaintFillerEntity> {
    private static float p = 0.0625f;
    private int lastWhite = 0;
    private int lastYellow = 0;
    private int lastRed = 0;
    private long lastTick = 0L;

    public void renderTileEntityFast(PaintFillerEntity te, double x, double y, double z, float partialTicks, int destroyStage, float partial, BufferBuilder buffer) {
        boolean rp;
        FluidStack white_paint = te.white_paint.getFluid();
        FluidStack yellow_paint = te.yellow_paint.getFluid();
        FluidStack red_paint = te.red_paint.getFluid();
        this.func_147499_a(TextureMap.field_110575_b);
        int meta = te.func_145838_q().func_176201_c(te.getState());
        boolean wp = white_paint != null;
        boolean yp = yellow_paint != null;
        boolean bl = rp = red_paint != null;
        if (wp && white_paint.amount > 0) {
            PaintFillerRenderer.renderTankFluid(buffer, x, y, z, 0, white_paint, meta);
        }
        if (yp && yellow_paint.amount > 0) {
            PaintFillerRenderer.renderTankFluid(buffer, x, y, z, 1, yellow_paint, meta);
        }
        if (rp && red_paint.amount > 0) {
            PaintFillerRenderer.renderTankFluid(buffer, x, y, z, 2, red_paint, meta);
        }
        if (wp && white_paint.amount > this.lastWhite) {
            PaintFillerRenderer.renderFillingFluid(buffer, x, y, z, 0, meta);
        }
        if (yp && yellow_paint.amount > this.lastYellow) {
            PaintFillerRenderer.renderFillingFluid(buffer, x, y, z, 1, meta);
        }
        if (rp && red_paint.amount > this.lastRed) {
            PaintFillerRenderer.renderFillingFluid(buffer, x, y, z, 2, meta);
        }
        if (this.func_178459_a().func_82737_E() - 5L > this.lastTick) {
            if (wp) {
                this.lastWhite = white_paint.amount;
            }
            if (yp) {
                this.lastYellow = yellow_paint.amount;
            }
            if (rp) {
                this.lastRed = red_paint.amount;
            }
            this.lastTick = this.func_178459_a().func_82737_E();
        }
        if (te.has_gun) {
            if (te.gun_white > 0) {
                PaintFillerRenderer.renderGunTankFluid(buffer, x, y, z, 0, te.gun_white, meta);
            }
            if (te.gun_yellow > 0) {
                PaintFillerRenderer.renderGunTankFluid(buffer, x, y, z, 1, te.gun_yellow, meta);
            }
            if (te.gun_red > 0) {
                PaintFillerRenderer.renderGunTankFluid(buffer, x, y, z, 2, te.gun_red, meta);
            }
            if (te.fuel_remaining > 0) {
                if (wp && te.gun_white < 32000 && white_paint.amount > 1000) {
                    PaintFillerRenderer.renderGunFillingFluid(buffer, x, y, z, 0, meta);
                }
                if (yp && te.gun_yellow < 32000 && yellow_paint.amount > 1000) {
                    PaintFillerRenderer.renderGunFillingFluid(buffer, x, y, z, 1, meta);
                }
                if (rp && te.gun_red < 32000 && red_paint.amount > 1000) {
                    PaintFillerRenderer.renderGunFillingFluid(buffer, x, y, z, 2, meta);
                }
            }
        }
    }

    private static void renderTankFluid(BufferBuilder buffer, double x, double y, double z, int col, FluidStack fluid, int meta) {
        float colourOffset = (float)col * 5.25f;
        if (fluid != null) {
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFluid().getStill(fluid).toString());
            if (meta == 0) {
                RenderHelper.renderTankFluid(buffer, x, y, z, 1.5f + colourOffset, 0.25f, 12.0f, 2.5f, 11.75f, 2.5f, fluid.amount, 32000, sprite);
            }
            if (meta == 1) {
                RenderHelper.renderTankFluid(buffer, x, y, z, 1.5f, 0.25f, 1.5f + colourOffset, 2.5f, 11.75f, 2.5f, fluid.amount, 32000, sprite);
            }
            if (meta == 2) {
                RenderHelper.renderTankFluid(buffer, x, y, z, 12.0f - colourOffset, 0.25f, 1.5f, 2.5f, 11.75f, 2.5f, fluid.amount, 32000, sprite);
            }
            if (meta == 3) {
                RenderHelper.renderTankFluid(buffer, x, y, z, 12.0f, 0.25f, 12.0f - colourOffset, 2.5f, 11.75f, 2.5f, fluid.amount, 32000, sprite);
            }
        }
    }

    private static void renderFillingFluid(BufferBuilder buffer, double x, double y, double z, int col, int meta) {
        float colourOffset = (float)col * 0.328125f;
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b("furenikusroads:items/paint_white");
        if (col == 1) {
            sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b("furenikusroads:items/paint_yellow");
        }
        if (col == 2) {
            sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b("furenikusroads:items/paint_red");
        }
        if (meta == 0) {
            RenderHelper.renderCube(buffer, x, y, z, 2.5f * p + colourOffset, 0.25f * p, 13.0f * p, 0.5f * p, 12.0f * p, 0.5f * p, sprite);
        }
        if (meta == 1) {
            RenderHelper.renderCube(buffer, x, y, z, 2.5f * p, 0.25f * p, 2.5f * p + colourOffset, 0.5f * p, 12.0f * p, 0.5f * p, sprite);
        }
        if (meta == 2) {
            RenderHelper.renderCube(buffer, x, y, z, 13.0f * p - colourOffset, 0.25f * p, 2.5f * p, 0.5f * p, 12.0f * p, 0.5f * p, sprite);
        }
        if (meta == 3) {
            RenderHelper.renderCube(buffer, x, y, z, 13.0f * p, 0.25f * p, 13.0f * p - colourOffset, 0.5f * p, 12.0f * p, 0.5f * p, sprite);
        }
    }

    private static void renderGunTankFluid(BufferBuilder buffer, double x, double y, double z, int col, int tankFill, int meta) {
        float colourOffset = (float)col * 0.125f;
        float fill = 5.3125E-4f * RenderHelper.getPercentage(tankFill, 32000.0f);
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b("furenikusroads:items/paint_white");
        if (col == 1) {
            sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b("furenikusroads:items/paint_yellow");
        }
        if (col == 2) {
            sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b("furenikusroads:items/paint_red");
        }
        if (meta == 0) {
            RenderHelper.renderCube(buffer, x, y, z, 11.5625f * p, 8.8f * p + colourOffset, 4.4375f * p, 0.875f * p, fill, 1.9375f * p, sprite);
        }
        if (meta == 1) {
            RenderHelper.renderCube(buffer, x, y, z, 9.5625f * p, 8.8f * p + colourOffset, 11.5625f * p, 1.9375f * p, fill, 0.875f * p, sprite);
        }
        if (meta == 2) {
            RenderHelper.renderCube(buffer, x, y, z, 3.5625f * p, 8.8f * p + colourOffset, 9.5625f * p, 0.875f * p, fill, 1.9375f * p, sprite);
        }
        if (meta == 3) {
            RenderHelper.renderCube(buffer, x, y, z, 4.4375f * p, 8.8f * p + colourOffset, 3.5625f * p, 1.9375f * p, fill, 0.875f * p, sprite);
        }
    }

    private static void renderGunFillingFluid(BufferBuilder buffer, double x, double y, double z, int col, int meta) {
        float colourOffset = (float)col * 0.125f;
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b("furenikusroads:items/paint_white");
        if (col == 1) {
            sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b("furenikusroads:items/paint_yellow");
        }
        if (col == 2) {
            sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b("furenikusroads:items/paint_red");
        }
        if (meta == 0) {
            RenderHelper.renderCube(buffer, x, y, z, 11.75f * p, 8.8f * p + colourOffset, 6.125f * p, 0.5f * p, 0.7f * p, 0.25f * p, sprite);
        }
        if (meta == 1) {
            RenderHelper.renderCube(buffer, x, y, z, 9.5625f * p, 8.8f * p + colourOffset, 11.75f * p, 0.25f * p, 0.7f * p, 0.5f * p, sprite);
        }
        if (meta == 2) {
            RenderHelper.renderCube(buffer, x, y, z, 3.75f * p, 8.8f * p + colourOffset, 9.5625f * p, 0.5f * p, 0.7f * p, 0.25f * p, sprite);
        }
        if (meta == 3) {
            RenderHelper.renderCube(buffer, x, y, z, 6.125f * p, 8.8f * p + colourOffset, 3.75f * p, 0.25f * p, 0.7f * p, 0.5f * p, sprite);
        }
    }
}

