/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.model;

import com.google.common.primitives.Ints;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import com.silvaniastudios.roads.items.PaintGun;
import com.silvaniastudios.roads.items.PaintGunItemRegistry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class PaintGunModel
implements IBakedModel {
    private IBakedModel mainModel;
    private final PaintGunOverrideList overrideList;
    private ItemStack stack;
    public static final ModelResourceLocation modelResourceLocation = new ModelResourceLocation("furenikusroads:paint_gun", "inventory");

    public PaintGunModel(IBakedModel mainModel) {
        this.mainModel = mainModel;
        this.overrideList = new PaintGunOverrideList(this);
        this.stack = null;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (!this.stack.func_77942_o()) {
            return this.mainModel.func_188616_a(state, side, rand);
        }
        NBTTagCompound nbt = this.stack.func_77978_p();
        int white_paint = nbt.func_74762_e("white_paint");
        int yellow_paint = nbt.func_74762_e("yellow_paint");
        int red_paint = nbt.func_74762_e("red_paint");
        ArrayList<BakedQuad> combinedQuadList = new ArrayList<BakedQuad>(this.mainModel.func_188616_a(state, side, rand));
        combinedQuadList.addAll(this.getTankFluid(2, white_paint));
        combinedQuadList.addAll(this.getTankFluid(1, yellow_paint));
        combinedQuadList.addAll(this.getTankFluid(0, red_paint));
        combinedQuadList.add(this.createDisplay(this.getDisplayTexture(nbt.func_74762_e("selectedId"), nbt.func_74762_e("pageId"), nbt.func_74762_e("colour"), nbt.func_74762_e("selMeta"))));
        return combinedQuadList;
    }

    public PaintGunModel setCurrentItemStack(ItemStack stack) {
        this.stack = stack;
        return this;
    }

    private float getPercentage(int num) {
        int max = 32000;
        float x = (float)num / (float)max;
        float y = x * 100.0f;
        if (y > 100.0f) {
            return 100.0f;
        }
        return y;
    }

    private TextureAtlasSprite getDisplayTexture(int selection, int pageId, int col, int meta) {
        PaintBlockBase block = PaintGun.getBlockFromSelection(selection, pageId);
        TextureAtlasSprite texture = Minecraft.func_71410_x().func_147117_R().func_110572_b("furenikusroads:blocks/blank");
        if (block != null) {
            if (col == 1) {
                block = PaintGunItemRegistry.getYellow(block);
            }
            if (col == 2) {
                block = PaintGunItemRegistry.getRed(block);
            }
            String name = block.func_149739_a().substring(20);
            String location = "items/paint_gun_display/";
            if (meta > 0 && pageId != 4) {
                name = name + "_" + meta;
            }
            if (pageId == 4) {
                location = "blocks/";
            }
            texture = Minecraft.func_71410_x().func_147117_R().func_110572_b("furenikusroads:" + location + name);
        }
        return texture;
    }

    private List<BakedQuad> getTankFluid(int col, int paintLevel) {
        TextureAtlasSprite texture = Minecraft.func_71410_x().func_147117_R().func_110572_b("furenikusroads:items/paint_red");
        if (col == 1) {
            texture = Minecraft.func_71410_x().func_147117_R().func_110572_b("furenikusroads:items/paint_yellow");
        }
        if (col == 2) {
            texture = Minecraft.func_71410_x().func_147117_R().func_110572_b("furenikusroads:items/paint_white");
        }
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        float fluidWidth = 0.0546875f;
        float backTankMiddle = 0.75390625f + fluidWidth / 2.0f;
        float baseHeight = 0.246875f;
        float fluidHeight = 0.0f;
        fluidHeight = this.getPercentage(paintLevel) * 0.00125f;
        list.add(this.createBakedQuadForFace(0.5f, fluidWidth, baseHeight + fluidHeight, 0.11875f, backTankMiddle - (float)col * 0.125f - fluidWidth / 2.0f, 0, texture, EnumFacing.NORTH));
        list.add(this.createBakedQuadForFace(0.5f, fluidWidth, baseHeight + fluidHeight, 0.11875f, backTankMiddle - (float)col * 0.125f + fluidWidth / 2.0f, 0, texture, EnumFacing.SOUTH));
        list.add(this.createBakedQuadForFace(backTankMiddle - (float)col * 0.125f, fluidWidth, baseHeight + fluidHeight, 0.11875f, 0.5f + fluidWidth / 2.0f, 0, texture, EnumFacing.EAST));
        list.add(this.createBakedQuadForFace(backTankMiddle - (float)col * 0.125f, fluidWidth, baseHeight + fluidHeight, 0.11875f, 0.5f - fluidWidth / 2.0f, 0, texture, EnumFacing.WEST));
        list.add(this.createBakedQuadForFace(0.5f, fluidWidth, 0.75f - (float)col * 0.125f + fluidWidth / 2.0f, fluidWidth, baseHeight + fluidHeight + 0.0585f, 0, texture, EnumFacing.UP));
        return list;
    }

    private BakedQuad createDisplay(TextureAtlasSprite texture) {
        float x4 = 0.2578125f;
        float y4 = 0.171875f;
        float z4 = 0.66375f;
        float x1 = 0.3671875f;
        float y1 = 0.171875f;
        float z1 = 0.66375f;
        float x2 = 0.3671875f;
        float y2 = 0.271875f;
        float z2 = 0.621875f;
        float x3 = 0.2578125f;
        float y3 = 0.271875f;
        float z3 = 0.621875f;
        int packednormal = this.calculatePackedNormal(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4);
        return new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(x1, y1, z1, Color.WHITE.getRGB(), texture, 16.0f, 16.0f, packednormal), this.vertexToInts(x2, y2, z2, Color.WHITE.getRGB(), texture, 16.0f, 0.0f, packednormal), this.vertexToInts(x3, y3, z3, Color.WHITE.getRGB(), texture, 0.0f, 0.0f, packednormal), this.vertexToInts(x4, y4, z4, Color.WHITE.getRGB(), texture, 0.0f, 16.0f, packednormal)}), 0, EnumFacing.SOUTH, texture, true, DefaultVertexFormats.field_176599_b);
    }

    private BakedQuad createBakedQuadForFace(float centreLR, float width, float centreUD, float height, float forwardDisplacement, int itemRenderLayer, TextureAtlasSprite texture, EnumFacing face) {
        float y1;
        float y2;
        float y3;
        float y4;
        float z2;
        float z3;
        float z1;
        float z4;
        float x3;
        float x4;
        float x1;
        float x2;
        switch (face) {
            case UP: {
                x1 = x2 = centreLR + width / 2.0f;
                x3 = x4 = centreLR - width / 2.0f;
                z1 = z4 = centreUD + height / 2.0f;
                z2 = z3 = centreUD - height / 2.0f;
                y3 = y4 = forwardDisplacement;
                y2 = y4;
                y1 = y4;
                break;
            }
            case DOWN: {
                x1 = x2 = centreLR + width / 2.0f;
                x3 = x4 = centreLR - width / 2.0f;
                z1 = z4 = centreUD - height / 2.0f;
                z2 = z3 = centreUD + height / 2.0f;
                y3 = y4 = forwardDisplacement;
                y2 = y4;
                y1 = y4;
                break;
            }
            case WEST: {
                z1 = z2 = centreLR + width / 2.0f;
                z3 = z4 = centreLR - width / 2.0f;
                y1 = y4 = centreUD - height / 2.0f;
                y2 = y3 = centreUD + height / 2.0f;
                x3 = x4 = forwardDisplacement;
                x2 = x4;
                x1 = x4;
                break;
            }
            case EAST: {
                z1 = z2 = centreLR - width / 2.0f;
                z3 = z4 = centreLR + width / 2.0f;
                y1 = y4 = centreUD - height / 2.0f;
                y2 = y3 = centreUD + height / 2.0f;
                x3 = x4 = forwardDisplacement;
                x2 = x4;
                x1 = x4;
                break;
            }
            case NORTH: {
                x1 = x2 = centreLR - width / 2.0f;
                x3 = x4 = centreLR + width / 2.0f;
                y1 = y4 = centreUD - height / 2.0f;
                y2 = y3 = centreUD + height / 2.0f;
                z3 = z4 = forwardDisplacement;
                z2 = z4;
                z1 = z4;
                break;
            }
            case SOUTH: {
                x1 = x2 = centreLR + width / 2.0f;
                x3 = x4 = centreLR - width / 2.0f;
                y1 = y4 = centreUD - height / 2.0f;
                y2 = y3 = centreUD + height / 2.0f;
                z3 = z4 = forwardDisplacement;
                z2 = z4;
                z1 = z4;
                break;
            }
            default: {
                assert (false) : "Unexpected facing in createBakedQuadForFace:" + face;
                return null;
            }
        }
        int packednormal = this.calculatePackedNormal(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4);
        return new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(x1, y1, z1, Color.WHITE.getRGB(), texture, 16.0f, 16.0f, packednormal), this.vertexToInts(x2, y2, z2, Color.WHITE.getRGB(), texture, 16.0f, 0.0f, packednormal), this.vertexToInts(x3, y3, z3, Color.WHITE.getRGB(), texture, 0.0f, 0.0f, packednormal), this.vertexToInts(x4, y4, z4, Color.WHITE.getRGB(), texture, 0.0f, 16.0f, packednormal)}), itemRenderLayer, face, texture, true, DefaultVertexFormats.field_176599_b);
    }

    private int[] vertexToInts(float x, float y, float z, int color, TextureAtlasSprite texture, float u, float v, int normal) {
        return new int[]{Float.floatToRawIntBits(x), Float.floatToRawIntBits(y), Float.floatToRawIntBits(z), color, Float.floatToRawIntBits(texture.func_94214_a((double)u)), Float.floatToRawIntBits(texture.func_94207_b((double)v)), normal};
    }

    private int calculatePackedNormal(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        float xp = x4 - x2;
        float yp = y4 - y2;
        float zp = z4 - z2;
        float xq = x3 - x1;
        float yq = y3 - y1;
        float zq = z3 - z1;
        float xn = yq * zp - zq * yp;
        float yn = zq * xp - xq * zp;
        float zn = xq * yp - yq * xp;
        float norm = (float)Math.sqrt(xn * xn + yn * yn + zn * zn);
        float SMALL_LENGTH = 1.0E-4f;
        if (norm < 1.0E-4f) {
            norm = 1.0f;
        }
        norm = 1.0f / norm;
        int x = (byte)((xn *= norm) * 127.0f) & 0xFF;
        int y = (byte)((yn *= norm) * 127.0f) & 0xFF;
        int z = (byte)((zn *= norm) * 127.0f) & 0xFF;
        return x | y << 8 | z << 16;
    }

    public boolean func_177555_b() {
        return this.mainModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrideList;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.mainModel.func_177552_f();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        Matrix4f matrix4f = (Matrix4f)this.mainModel.handlePerspective(cameraTransformType).getRight();
        return Pair.of((Object)this, (Object)matrix4f);
    }

    private static class PaintGunOverrideList
    extends ItemOverrideList {
        private PaintGunModel model;

        public PaintGunOverrideList(PaintGunModel model) {
            super(Collections.emptyList());
            this.model = model;
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            return this.model.setCurrentItemStack(stack);
        }
    }
}

