/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.client.FMLClientHandler;

public class RenderHelper {
    private static final VertexFormat ITEM_FORMAT_WITH_LIGHTMAP = new VertexFormat(DefaultVertexFormats.field_176599_b).func_181721_a(DefaultVertexFormats.field_181716_p);

    public static void renderTankFluid(BufferBuilder buffer, double x, double y, double z, float posX, float posY, float posZ, float sizeX, float sizeY, float sizeZ, int tankFill, int tankCap, TextureAtlasSprite sprite) {
        float fill = sizeY / 100.0f * RenderHelper.getPercentage(tankFill, tankCap);
        float p = 0.0625f;
        RenderHelper.renderScaledCube(buffer, x, y, z, posX * p, posY * p, posZ * p, sizeX * p, fill * p, sizeZ * p, sprite);
    }

    public static void renderScaledCube(BufferBuilder buffer, double x, double y, double z, float xLow, float yLow, float zLow, float xSize, float ySize, float zSize, TextureAtlasSprite texture) {
        int red = 255;
        int green = 255;
        int blue = 255;
        int alpha = 255;
        float xHigh = xLow + xSize;
        float yHigh = yLow + ySize;
        float zHigh = zLow + zSize;
        double minU = texture.func_94214_a((double)(xLow * 16.0f));
        double minV = texture.func_94207_b((double)(zLow * 16.0f));
        double maxU = texture.func_94214_a((double)(xHigh * 16.0f));
        double maxV = texture.func_94207_b((double)(zHigh * 16.0f));
        buffer.func_181662_b(x + (double)xHigh, y + (double)yHigh, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(minU, maxV).func_187314_a(240, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yHigh, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, maxV).func_187314_a(240, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yHigh, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, minV).func_187314_a(240, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yHigh, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(minU, minV).func_187314_a(240, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yLow, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(minU, maxV).func_187314_a(168, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yLow, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(minU, minV).func_187314_a(168, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yLow, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, minV).func_187314_a(168, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yLow, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, maxV).func_187314_a(168, 0).func_181675_d();
        minU = texture.func_94214_a((double)(xLow * 16.0f));
        minV = texture.func_94207_b((double)(yLow * 16.0f));
        maxU = texture.func_94214_a((double)(xHigh * 16.0f));
        maxV = texture.func_94207_b((double)(yHigh * 16.0f));
        buffer.func_181662_b(x + (double)xLow, y + (double)yLow, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(minU, maxV).func_187314_a(216, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yHigh, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(minU, minV).func_187314_a(216, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yHigh, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, minV).func_187314_a(216, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yLow, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, maxV).func_187314_a(216, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yLow, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(minU, maxV).func_187314_a(216, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yHigh, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(minU, minV).func_187314_a(216, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yHigh, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, minV).func_187314_a(216, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yLow, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, maxV).func_187314_a(216, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yLow, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(minU, maxV).func_187314_a(192, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yHigh, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(minU, minV).func_187314_a(192, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yHigh, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, minV).func_187314_a(192, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yLow, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, maxV).func_187314_a(192, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yLow, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(minU, maxV).func_187314_a(192, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yHigh, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(minU, minV).func_187314_a(192, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yHigh, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, minV).func_187314_a(192, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yLow, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, maxV).func_187314_a(192, 0).func_181675_d();
    }

    public static void renderCube(BufferBuilder buffer, double x, double y, double z, float xLow, float yLow, float zLow, float xSize, float ySize, float zSize, TextureAtlasSprite texture) {
        int red = 255;
        int green = 255;
        int blue = 255;
        int alpha = 255;
        double minU = texture.func_94209_e();
        double maxU = texture.func_94212_f();
        double minV = texture.func_94206_g();
        double maxV = texture.func_94210_h();
        float xHigh = xLow + xSize;
        float yHigh = yLow + ySize;
        float zHigh = zLow + zSize;
        buffer.func_181662_b(x + (double)xHigh, y + (double)yHigh, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(minU, maxV).func_187314_a(240, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yHigh, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(minU, minV).func_187314_a(240, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yHigh, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, minV).func_187314_a(240, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yHigh, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, maxV).func_187314_a(240, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yLow, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(minU, maxV).func_187314_a(168, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yLow, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(minU, minV).func_187314_a(168, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yLow, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, minV).func_187314_a(168, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yLow, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, maxV).func_187314_a(168, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yLow, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(minU, maxV).func_187314_a(216, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yHigh, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(minU, minV).func_187314_a(216, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yHigh, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, minV).func_187314_a(216, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yLow, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, maxV).func_187314_a(216, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yLow, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(minU, maxV).func_187314_a(216, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yHigh, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(minU, minV).func_187314_a(216, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yHigh, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, minV).func_187314_a(216, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yLow, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, maxV).func_187314_a(216, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yLow, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(minU, maxV).func_187314_a(192, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yHigh, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(minU, minV).func_187314_a(192, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yHigh, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, minV).func_187314_a(192, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xLow, y + (double)yLow, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, maxV).func_187314_a(192, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yLow, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(minU, maxV).func_187314_a(192, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yHigh, z + (double)zHigh).func_181669_b(255, 255, 255, 255).func_187315_a(minU, minV).func_187314_a(192, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yHigh, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, minV).func_187314_a(192, 0).func_181675_d();
        buffer.func_181662_b(x + (double)xHigh, y + (double)yLow, z + (double)zLow).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, maxV).func_187314_a(192, 0).func_181675_d();
    }

    public static void renderFlatQuad(BufferBuilder buffer, TextureAtlasSprite texture, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        int red = 255;
        int green = 255;
        int blue = 255;
        int alpha = 255;
        double minU = texture.func_94209_e();
        double maxU = texture.func_94212_f();
        double minV = texture.func_94206_g();
        double maxV = texture.func_94210_h();
        int lightmap1 = 240;
        boolean lightmap2 = false;
        buffer.func_181662_b((double)x1, (double)y1, (double)z1).func_181669_b(255, 255, 255, 255).func_187315_a(minU, maxV).func_187314_a(240, 0).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y2, (double)z2).func_181669_b(255, 255, 255, 255).func_187315_a(minU, minV).func_187314_a(240, 0).func_181675_d();
        buffer.func_181662_b((double)x3, (double)y3, (double)z3).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, minV).func_187314_a(240, 0).func_181675_d();
        buffer.func_181662_b((double)x4, (double)y4, (double)z4).func_181669_b(255, 255, 255, 255).func_187315_a(maxU, maxV).func_187314_a(240, 0).func_181675_d();
    }

    public static float getPercentage(float num, float max) {
        float x = num / max;
        float y = x * 100.0f;
        if (y > 100.0f) {
            return 100.0f;
        }
        return y;
    }

    public static BakedQuad setBrightTexture(BakedQuad quad, final float light) {
        if (FMLClientHandler.instance().hasOptifine()) {
            return quad;
        }
        if (!ForgeModContainer.forgeLightPipelineEnabled) {
            return quad;
        }
        VertexFormat newFormat = RenderHelper.getFormatWithLightMap(quad.getFormat());
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(newFormat);
        VertexLighterFlat trans = new VertexLighterFlat(Minecraft.func_71410_x().func_184125_al()){

            protected void updateLightmap(float[] normal, float[] lightmap, float x, float y, float z) {
                lightmap[0] = light;
                lightmap[1] = light;
            }

            public void setQuadTint(int tint) {
            }
        };
        trans.setParent((IVertexConsumer)builder);
        quad.pipe((IVertexConsumer)trans);
        builder.setQuadTint(quad.func_178211_c());
        builder.setQuadOrientation(quad.func_178210_d());
        builder.setTexture(quad.func_187508_a());
        builder.setApplyDiffuseLighting(false);
        return builder.build();
    }

    public static VertexFormat getFormatWithLightMap(VertexFormat format) {
        if (FMLClientHandler.instance().hasOptifine() || !ForgeModContainer.forgeLightPipelineEnabled) {
            return format;
        }
        if (format == DefaultVertexFormats.field_176600_a) {
            return DefaultVertexFormats.field_176600_a;
        }
        if (format == DefaultVertexFormats.field_176599_b) {
            return ITEM_FORMAT_WITH_LIGHTMAP;
        }
        if (!format.func_177347_a(1)) {
            VertexFormat result = new VertexFormat(format);
            result.func_181721_a(DefaultVertexFormats.field_181716_p);
            return result;
        }
        return format;
    }

    public static int[] vertexToInts(float x, float y, float z, int color, TextureAtlasSprite texture, float u, float v, int normal) {
        return new int[]{Float.floatToRawIntBits(x), Float.floatToRawIntBits(y), Float.floatToRawIntBits(z), color, Float.floatToRawIntBits(texture.func_94214_a((double)u)), Float.floatToRawIntBits(texture.func_94207_b((double)v)), normal};
    }

    public static int calculatePackedNormal(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        float xp = x4 - x2;
        float yp = y4 - y2;
        float zp = z4 - z2;
        float xq = x3 - x1;
        float yq = y3 - y1;
        float zq = z3 - z1;
        float xn = yq * zp - zq * yp;
        float yn = zq * xp - xq * zp;
        float zn = xq * yp - yq * xp;
        float norm = (float)Math.sqrt(xn * xn + yn * yn + zn * zn);
        float SMALL_LENGTH = 1.0E-4f;
        if (norm < 1.0E-4f) {
            norm = 1.0f;
        }
        norm = 1.0f / norm;
        int x = (byte)((xn *= norm) * 127.0f) & 0xFF;
        int y = (byte)((yn *= norm) * 127.0f) & 0xFF;
        int z = (byte)((zn *= norm) * 127.0f) & 0xFF;
        return x | y << 8 | z << 16;
    }
}

