/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.jei;

import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.FRBlocks;
import com.silvaniastudios.roads.jei.TarDistillerWrapper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TarDistillerCategory
implements IRecipeCategory<TarDistillerWrapper> {
    private final IDrawable background;
    private final IDrawable electric_bar;
    private final IDrawable icon;
    private final IDrawableAnimated progressBar;
    private final IDrawable tankCover;
    public static final int width = 184;
    public static final int height = 112;
    private boolean electric = false;
    private String uid;

    public TarDistillerCategory(IGuiHelper guiHelper, String uid, boolean electric) {
        ResourceLocation guiTexture = new ResourceLocation("furenikusroads:textures/gui/jei_texture_2.png");
        this.background = guiHelper.createDrawable(guiTexture, 0, 114, 184, 112);
        this.electric_bar = guiHelper.createDrawable(guiTexture, 186, 114, 18, 112);
        this.icon = electric ? guiHelper.createDrawableIngredient((Object)new ItemStack((Block)FRBlocks.tar_distiller_electric)) : guiHelper.createDrawableIngredient((Object)new ItemStack((Block)FRBlocks.tar_distiller));
        int progressTick = electric ? RoadsConfig.machine.electricTarDistillerTickRate : RoadsConfig.machine.tarDistillerTickRate;
        this.progressBar = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(guiTexture, 0, 252, 160, 4), progressTick, IDrawableAnimated.StartDirection.LEFT, false);
        this.electric = electric;
        this.uid = uid;
        this.tankCover = guiHelper.createDrawable(guiTexture, 236, 0, 20, 100);
    }

    public String getUid() {
        return this.uid;
    }

    public String getTitle() {
        if (this.electric) {
            return I18n.func_135052_a((String)"roads.gui.electric_tar_distiller.name", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"roads.gui.tar_distiller.name", (Object[])new Object[0]);
    }

    public String getModName() {
        return "Fureniku's Roads";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        if (this.electric) {
            this.electric_bar.draw(minecraft, 166, 0);
        }
        this.progressBar.draw(minecraft, 1, 107);
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, TarDistillerWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup itemStack = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStack = recipeLayout.getFluidStacks();
        itemStack.init(0, true, 26, 22);
        itemStack.init(1, false, 92, 0);
        itemStack.init(2, false, 92, 22);
        if (!this.electric) {
            itemStack.init(3, true, 166, 22);
        }
        fluidStack.init(10, true, 1, 1, 20, 100, 320000, true, this.tankCover);
        fluidStack.init(11, false, 115, 1, 20, 100, 320000, true, this.tankCover);
        fluidStack.init(12, false, 141, 1, 20, 100, 320000, true, this.tankCover);
        itemStack.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        if (!this.electric) {
            itemStack.set(3, new ItemStack(Items.field_151129_at));
        }
        itemStack.set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        itemStack.set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(1));
        int in = ingredients.getInputs(VanillaTypes.FLUID).size();
        int out = ingredients.getOutputs(VanillaTypes.FLUID).size();
        if (in > 0) {
            fluidStack.set(10, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        }
        if (out > 0) {
            fluidStack.set(11, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
        }
        if (out > 1) {
            fluidStack.set(12, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(1));
        }
    }
}

