/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.jei;

import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.FRBlocks;
import com.silvaniastudios.roads.items.FRItems;
import com.silvaniastudios.roads.jei.TarmacCutterWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TarmacCutterCategory
implements IRecipeCategory<TarmacCutterWrapper> {
    private final IDrawable background;
    private final IDrawable electric_bar;
    private final IDrawable icon;
    private final IDrawableAnimated progressBar;
    public static final int width = 162;
    public static final int height = 52;
    private String uid;
    private boolean electric = false;

    public TarmacCutterCategory(IGuiHelper guiHelper, String uid, boolean electric) {
        ResourceLocation guiTexture = new ResourceLocation("furenikusroads:textures/gui/jei_texture_1.png");
        this.background = guiHelper.createDrawable(guiTexture, 0, 54, 162, 52);
        this.electric_bar = guiHelper.createDrawable(guiTexture, 164, 0, 18, 52);
        this.icon = electric ? guiHelper.createDrawableIngredient((Object)new ItemStack((Block)FRBlocks.tarmac_cutter_electric)) : guiHelper.createDrawableIngredient((Object)new ItemStack((Block)FRBlocks.tarmac_cutter));
        int progressTick = electric ? RoadsConfig.machine.electricTarmacCutterTickRate : RoadsConfig.machine.tarmacCutterTickRate;
        this.progressBar = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(guiTexture, 0, 252, 160, 4), progressTick, IDrawableAnimated.StartDirection.LEFT, false);
        this.electric = electric;
        this.uid = uid;
    }

    public String getUid() {
        return this.uid;
    }

    public String getTitle() {
        if (this.electric) {
            return I18n.func_135052_a((String)"roads.gui.electric_tarmac_cutter.name", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"roads.gui.tarmac_cutter.name", (Object[])new Object[0]);
    }

    public String getModName() {
        return "Fureniku's Roads";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        if (this.electric) {
            this.electric_bar.draw(minecraft, 144, 0);
        }
        this.progressBar.draw(minecraft, 1, 47);
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, TarmacCutterWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiStack = recipeLayout.getItemStacks();
        ArrayList<ItemStack> blade_1 = new ArrayList<ItemStack>();
        ArrayList<ItemStack> blade_2 = new ArrayList<ItemStack>();
        ArrayList<ItemStack> blade_4 = new ArrayList<ItemStack>();
        ArrayList<ItemStack> blade_8 = new ArrayList<ItemStack>();
        blade_1.add(new ItemStack((Item)FRItems.tarmac_cutter_blade_1_diamond));
        blade_1.add(new ItemStack((Item)FRItems.tarmac_cutter_blade_1_gold));
        blade_1.add(new ItemStack((Item)FRItems.tarmac_cutter_blade_1_iron));
        blade_2.add(new ItemStack((Item)FRItems.tarmac_cutter_blade_2_diamond));
        blade_2.add(new ItemStack((Item)FRItems.tarmac_cutter_blade_2_gold));
        blade_2.add(new ItemStack((Item)FRItems.tarmac_cutter_blade_2_iron));
        blade_4.add(new ItemStack((Item)FRItems.tarmac_cutter_blade_4_diamond));
        blade_4.add(new ItemStack((Item)FRItems.tarmac_cutter_blade_4_gold));
        blade_4.add(new ItemStack((Item)FRItems.tarmac_cutter_blade_4_iron));
        blade_8.add(new ItemStack((Item)FRItems.tarmac_cutter_blade_8_diamond));
        blade_8.add(new ItemStack((Item)FRItems.tarmac_cutter_blade_8_gold));
        blade_8.add(new ItemStack((Item)FRItems.tarmac_cutter_blade_8_iron));
        guiStack.init(0, true, 0, 24);
        guiStack.init(1, true, 45, 24);
        guiStack.init(2, false, 90, 24);
        guiStack.init(3, false, 108, 24);
        ItemStack fragments = (ItemStack)((List)ingredients.getOutputs(VanillaTypes.ITEM).get(1)).get(0);
        guiStack.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        if (fragments.func_190916_E() == 1) {
            guiStack.set(1, blade_1);
        } else if (fragments.func_190916_E() == 2) {
            guiStack.set(1, blade_2);
        } else if (fragments.func_190916_E() == 4) {
            guiStack.set(1, blade_4);
        } else {
            guiStack.set(1, blade_8);
        }
        guiStack.set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        guiStack.set(3, fragments);
    }
}

