/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.grue.common.integrations.gamestages;

import com.shinoow.grue.Grue;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.Loader;

public class GameStagesHandler {
    private static Map<String, Integer> GRUE_SPAWNS = new HashMap<String, Integer>();
    private static Map<String, Integer> GRUE_DOESNT_SPAWN = new HashMap<String, Integer>();

    public static void init() {
        GRUE_SPAWNS = Arrays.stream(Grue.spawn_stages).map(s -> s.split(":")).collect(Collectors.toMap(s -> s[0], s -> Integer.parseInt(s[1])));
        GRUE_DOESNT_SPAWN = Arrays.stream(Grue.nospawn_stages).map(s -> s.split(":")).collect(Collectors.toMap(s -> s[0], s -> Integer.parseInt(s[1])));
    }

    public static boolean shouldGrueSpawn(EntityPlayer player) {
        if (!Loader.isModLoaded((String)"gamestages")) {
            return true;
        }
        int spawn_priority = 0;
        int doesntspawn_priority = 0;
        Collection stages = GameStageHelper.getPlayerData((EntityPlayer)player).getStages();
        for (String stage : stages) {
            Integer doesntspawn_value;
            Integer spawn_value = GRUE_SPAWNS.get(stage);
            if (spawn_value != null && spawn_value > spawn_priority) {
                spawn_priority = spawn_value;
            }
            if ((doesntspawn_value = GRUE_DOESNT_SPAWN.get(stage)) == null || doesntspawn_value <= doesntspawn_priority) continue;
            doesntspawn_priority = doesntspawn_value;
        }
        return spawn_priority > doesntspawn_priority || spawn_priority == 0 && doesntspawn_priority == 0;
    }
}

