/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client;

import net.minecraft.block.AirBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import shetiphian.core.common.Function;

@OnlyIn(value=Dist.CLIENT)
public abstract class SoundHandler {
    private Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void playSound(PlaySoundEvent event) {
        ISound sound;
        SoundCategory category = event.getSound().func_184365_d();
        if ((category == null || category == SoundCategory.BLOCKS || category == SoundCategory.NEUTRAL || category == SoundCategory.HOSTILE) && (sound = event.getSound()).func_184364_b() != null) {
            event.setResultSound(this.onPlaySound(sound, category, event.getName(), sound.func_147653_e(), sound.func_147655_f(), sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i()));
        }
    }

    protected abstract ISound onPlaySpecialSound(ISound var1, SoundCategory var2, String var3, float var4, float var5, int var6, int var7, int var8);

    protected abstract ISound onPlayPlaceBreakSound(ISound var1, SoundCategory var2, String var3, float var4, float var5, int var6, int var7, int var8, BlockState var9);

    protected abstract ISound onPlayWalkFallSound(ISound var1, SoundCategory var2, String var3, float var4, float var5, int var6, int var7, int var8, BlockState var9);

    private ISound onPlaySound(ISound sound, SoundCategory category, String name, float volume, float pitch, float sx, float sy, float sz) {
        ISound newSound;
        BlockState state;
        ISound newSound2;
        int[] blockXZ = Function.getBlockXZ(sx, sz);
        int x = blockXZ[0];
        int z = blockXZ[1];
        int y = (int)sy;
        if (sy - (float)y > 0.0f) {
            ++y;
        }
        if (!name.startsWith("dig") && !name.startsWith("step") && sound != (newSound2 = this.onPlaySpecialSound(sound, category, name, volume, pitch, x, y, z))) {
            return newSound2;
        }
        if (name.startsWith("dig")) {
            state = this.mc.field_71441_e.func_180495_p(new BlockPos(x, y, z));
            if (state.func_177230_c() instanceof AirBlock) {
                state = this.mc.field_71441_e.func_180495_p(new BlockPos(x, y - 1, z));
            }
            if (sound != (newSound = this.onPlayPlaceBreakSound(sound, category, name, volume, pitch, x, y, z, state))) {
                return newSound;
            }
        }
        if (name.startsWith("step") && sound != (newSound = this.onPlayWalkFallSound(sound, category, name, volume, pitch, x, y, z, state = this.mc.field_71441_e.func_180495_p(new BlockPos(x, y - 1, z))))) {
            return newSound;
        }
        return sound;
    }

    protected ISound getPlaceSound(SoundType sound, SoundCategory category, float volume, float pitch, float x, float y, float z) {
        return this.getSound(sound.func_185841_e().func_187503_a(), category, volume, pitch, x, y, z);
    }

    protected ISound getBreakSound(SoundType sound, SoundCategory category, float volume, float pitch, float x, float y, float z) {
        return this.getSound(sound.func_185845_c().func_187503_a(), category, volume, pitch, x, y, z);
    }

    protected ISound getStepSound(SoundType sound, SoundCategory category, float volume, float pitch, float x, float y, float z) {
        return this.getSound(sound.func_185844_d().func_187503_a(), category, volume, pitch, x, y, z);
    }

    protected ISound getSound(ResourceLocation soundId, SoundCategory category, float volume, float pitch, float x, float y, float z) {
        return new SimpleSound(soundId, category, volume, pitch, false, 0, ISound.AttenuationType.LINEAR, x, y, z, false);
    }
}

