/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.model;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Either;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class RetexturedBlockModel
extends BlockModel {
    private Map<String, Material> replacements = new HashMap<String, Material>();

    public static RetexturedBlockModel from(BlockModel original) {
        ItemCameraTransforms cameraTransforms;
        Field ctFeild = ObfuscationReflectionHelper.findField(BlockModel.class, (String)"field_178320_j");
        try {
            cameraTransforms = (ItemCameraTransforms)ctFeild.get(original);
        }
        catch (Exception ignored) {
            cameraTransforms = ItemCameraTransforms.field_178357_a;
        }
        return new RetexturedBlockModel(original.getParentLocation(), original.func_178298_a(), original.field_178318_c, original.field_178322_i, original.func_230176_c_(), cameraTransforms, original.func_187966_f());
    }

    public RetexturedBlockModel(@Nullable ResourceLocation parentLocation, List<BlockPart> elements, Map<String, Either<Material, String>> textures, boolean ambientOcclusion, @Nullable BlockModel.GuiLight guiLight, ItemCameraTransforms cameraTransforms, List<ItemOverride> overrides) {
        super(parentLocation, elements, textures, ambientOcclusion, guiLight, cameraTransforms, overrides);
    }

    public Material func_228816_c_(String name) {
        if (name.charAt(0) == '#') {
            name = name.substring(1);
        }
        return this.replacements.containsKey(name) ? this.replacements.get(name) : super.func_228816_c_(name);
    }

    public void replaceTexture(String name, Material texture) {
        this.replacements.put(name, texture);
    }

    public void replaceTexture(String name, ResourceLocation texture) {
        this.replacements.put(name, new Material(PlayerContainer.field_226615_c_, texture));
    }

    public RetexturedBlockModel retexture(ImmutableMap<String, String> textures) {
        textures.forEach((name, texture) -> this.replaceTexture((String)name, new ResourceLocation(texture)));
        return this;
    }
}

