/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.common.NameHelper;
import shetiphian.core.internal.modintegration.ftblib.FTBLib_Base;

public class Function {
    public static final String[] dyeNamesWB = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    public static final String[] dyeNamesBW = new String[]{"black", "red", "green", "brown", "blue", "purple", "cyan", "light_gray", "gray", "pink", "lime", "yellow", "light_blue", "magenta", "orange", "white"};
    public static final String dyeTagPrefix = "forge:dyes/";
    private static final HashMap<String, Collection<Item>> cache = new HashMap();
    public static Random random = new Random();

    public static boolean setBlock(IWorld world, BlockPos pos, BlockState state, boolean doBlockUpdate) {
        int update = doBlockUpdate ? 11 : 26;
        return world.func_180501_a(pos, state, update);
    }

    public static void syncTile(TileEntity tile) {
        tile.func_70296_d();
        BlockState state = tile.func_195044_w();
        Function.sync(tile.func_145831_w(), tile.func_174877_v(), state);
    }

    public static void sync(World world, BlockPos pos, BlockState state) {
        world.func_184138_a(pos, state, state, 11);
    }

    public static void updateLighting(TileEntity tile) {
        tile.func_145831_w().func_226658_a_(LightType.BLOCK, tile.func_174877_v());
        BlockState state = tile.func_195044_w();
        Function.sync(tile.func_145831_w(), tile.func_174877_v(), state);
    }

    public static Block getBlockDown(IBlockReader world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c();
    }

    public static int[] getBlockXZ(double posX, double posZ) {
        int blockX = (int)posX;
        int blockZ = (int)posZ;
        if (posX - (double)((int)posX) < 0.0) {
            --blockX;
        }
        if (posZ - (double)((int)posZ) < 0.0) {
            // empty if block
        }
        return new int[]{blockX, --blockZ};
    }

    public static boolean giveItem(PlayerEntity player, ItemStack stack) {
        return Function.giveItem(player, stack, SoundEvents.field_187638_cR);
    }

    public static boolean giveItem(PlayerEntity player, ItemStack stack, SoundEvent sound) {
        if (!player.field_71071_by.func_70441_a(stack)) {
            Function.dropItem(player.func_130014_f_(), new BlockPos(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()), stack);
            return false;
        }
        if (sound != null) {
            player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), sound, player.func_184176_by(), 0.2f, ((player.func_130014_f_().field_73012_v.nextFloat() - player.func_130014_f_().field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        return true;
    }

    public static void dropItem(World world, BlockPos pos, ItemStack stack) {
        if (!world.field_72995_K && !stack.func_190926_b()) {
            double rndX = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double rndY = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double rndZ = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            ItemEntity entityItem = new ItemEntity(world, (double)pos.func_177958_n() + rndX, (double)pos.func_177956_o() + rndY, (double)pos.func_177952_p() + rndZ, stack);
            entityItem.func_174867_a(10);
            if (stack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
            }
            world.func_217376_c((Entity)entityItem);
        }
    }

    @Nonnull
    public static ItemStack findItemStack(String modId, String name) {
        return Function.findItemStack(1, modId, name);
    }

    @Nonnull
    public static ItemStack findItemStack(int count, String modId, String name) {
        ResourceLocation resource = new ResourceLocation(modId, name);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(resource);
        if (item != null) {
            return new ItemStack((IItemProvider)item, count < 1 ? 1 : count);
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(resource);
        if (block != null) {
            return new ItemStack((IItemProvider)block, count < 1 ? 1 : count);
        }
        return ItemStack.field_190927_a;
    }

    public static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB) {
        return Function.areItemStacksEqual(stackA, stackB, false);
    }

    public static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB, boolean excludeNBT) {
        boolean areEqual;
        if (stackA.func_190926_b() && stackB.func_190926_b()) {
            return true;
        }
        if (stackA.func_190926_b() || stackB.func_190926_b()) {
            return false;
        }
        boolean bl = areEqual = stackA.func_77973_b() == stackB.func_77973_b();
        return excludeNBT ? areEqual : areEqual && ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean areFluidStacksEqual(FluidStack stackA, FluidStack stackB) {
        return stackA == null && stackB == null || stackA != null && stackB != null && stackA.isFluidEqual(stackB);
    }

    public static Collection<Item> getOres(String name) {
        if (!cache.containsKey(name = name.toLowerCase())) {
            String modId = name.contains(":") ? name.split(":")[0] : "minecraft";
            String nameId = name.contains(":") ? name.split(":")[1] : name;
            Tag tag = ItemTags.func_199903_a().func_199910_a(new ResourceLocation(modId, nameId.replaceAll("\\.", "/")));
            cache.put(name, tag != null ? tag.func_199885_a() : Collections.emptyList());
        }
        return cache.get(name);
    }

    @Nonnull
    public static ItemStack getOre(String name, int ... stackSize) {
        Collection<Item> results;
        int amount;
        int n = amount = stackSize != null && stackSize.length > 0 ? stackSize[0] : 1;
        if (amount > 0 && (results = Function.getOres(name)) != null && !results.isEmpty()) {
            for (Item item : results) {
                if (item == null) continue;
                return new ItemStack((IItemProvider)item, amount);
            }
        }
        return ItemStack.field_190927_a;
    }

    public static void attemptAdd(List<ItemStack> list, ItemStack itemStack) {
        if (itemStack != null && itemStack.func_190916_E() > 0) {
            list.add(itemStack);
        }
    }

    public static String getEntityName(LivingEntity entity) {
        return entity.func_145748_c_().getString();
    }

    public static boolean isOP(PlayerEntity player) {
        MinecraftServer server = player.func_130014_f_().func_73046_m();
        if (server == null) {
            server = ServerLifecycleHooks.getCurrentServer();
        }
        if (server == null) {
            return ShetiPhianCore.PROXY.isClientOp(player);
        }
        if (server.func_71264_H() && player.field_71075_bZ.field_75098_d) {
            return true;
        }
        String[] ops = null;
        try {
            ops = server.func_184103_al().func_152603_m().func_152685_a();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ops != null) {
            for (String op : ops) {
                if (!op.equals(player.func_145748_c_().getString())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCreativeOP(PlayerEntity player) {
        return player.field_71075_bZ.field_75098_d && Function.isOP(player);
    }

    public static String getPlayerTeamID(PlayerEntity player) {
        if (player != null) {
            Team team;
            String teamID = FTBLib_Base.INSTANCE.getPlayerTeamID(player);
            if (Strings.isNullOrEmpty((String)teamID) && (team = player.func_96124_cp()) != null) {
                return team.func_96661_b();
            }
            return teamID;
        }
        return "";
    }

    public static String getTeamDisplayName(String teamID) {
        return !Strings.isNullOrEmpty((String)teamID) ? NameHelper.getLastKnownTeamName(teamID) : teamID;
    }

    public static int getSubShapeHit(Entity entity, BlockPos pos, VoxelShape ... shapes) {
        double distance = 5.0;
        Vec3d vecStart = new Vec3d(entity.field_70169_q, entity.field_70167_r + (double)entity.func_70047_e(), entity.field_70166_s);
        Vec3d vecLook = entity.func_70676_i(0.0f);
        Vec3d vecEnd = vecStart.func_72441_c(vecLook.field_72450_a * distance, vecLook.field_72448_b * distance, vecLook.field_72449_c * distance);
        int shapeIndex = -1;
        double hitDistance = 100.0;
        for (int index = 0; index < shapes.length; index = (int)((byte)(index + 1))) {
            double shapeDistance;
            BlockRayTraceResult shapeHit = shapes[index].func_212433_a(vecStart, vecEnd, pos);
            if (shapeHit == null || !((shapeDistance = shapeHit.func_216347_e().func_72436_e(vecStart)) < hitDistance)) continue;
            hitDistance = shapeDistance;
            shapeIndex = index;
        }
        return shapeIndex;
    }

    public static BlockRayTraceResult fakeMOP(BlockPos pos, Direction face) {
        Vec3d vec3 = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        return new BlockRayTraceResult(vec3, face, pos, false);
    }

    public static BlockRayTraceResult rayTrace(Entity entity, double blockReachDistance, float partialTicks) {
        Vec3d vecStart;
        if (partialTicks == 1.0f) {
            vecStart = new Vec3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_());
        } else {
            double d0 = entity.field_70169_q + (entity.func_226277_ct_() - entity.field_70169_q) * (double)partialTicks;
            double d1 = entity.field_70167_r + (entity.func_226278_cu_() - entity.field_70167_r) * (double)partialTicks + (double)entity.func_70047_e();
            double d2 = entity.field_70166_s + (entity.func_226281_cx_() - entity.field_70166_s) * (double)partialTicks;
            vecStart = new Vec3d(d0, d1, d2);
        }
        Vec3d vecLook = entity.func_70676_i(partialTicks);
        Vec3d vecEnd = vecStart.func_72441_c(vecLook.field_72450_a * blockReachDistance, vecLook.field_72448_b * blockReachDistance, vecLook.field_72449_c * blockReachDistance);
        return entity.func_130014_f_().func_217299_a(new RayTraceContext(vecStart, vecEnd, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, entity));
    }

    public static Entity getLivingEntityInFront(World world, Entity entity, double distance) {
        if (entity == null || world == null || distance < 1.0) {
            return null;
        }
        Vec3d vecStart = new Vec3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_());
        Vec3d vecLook = entity.func_70676_i(1.0f);
        Vec3d vecEnd = vecStart.func_72441_c(vecLook.field_72450_a * distance, vecLook.field_72448_b * distance, vecLook.field_72449_c * distance);
        LivingEntity theTarget = null;
        float closestHit = Float.POSITIVE_INFINITY;
        List entityList = entity.func_130014_f_().func_217357_a(LivingEntity.class, new AxisAlignedBB(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.func_226277_ct_() + 1.0, entity.func_226278_cu_() + 1.0, entity.func_226281_cx_() + 1.0).func_72321_a(distance, distance, distance));
        if (entityList.isEmpty()) {
            return null;
        }
        for (LivingEntity livingEntity : entityList) {
            float currentHit;
            Optional intercept;
            AxisAlignedBB boundingBox;
            if (!livingEntity.func_70067_L() || (boundingBox = livingEntity.func_174813_aQ()) == null || !(intercept = boundingBox.func_216365_b(vecStart, vecEnd)).isPresent() || !((currentHit = (float)((Vec3d)intercept.get()).func_72438_d(vecStart)) < closestHit) && currentHit != 0.0f) continue;
            closestHit = currentHit;
            theTarget = livingEntity;
        }
        return theTarget;
    }

    public static BlockInfo getBlockInfront(World world, Entity entity, double reach, boolean includeLiquids) {
        RayTraceResult mop = Function.getMovingObjectPosition(world, entity, includeLiquids, reach);
        if (mop instanceof BlockRayTraceResult) {
            return new BlockInfo(world, (BlockRayTraceResult)mop);
        }
        return null;
    }

    public static RayTraceResult getMovingObjectPosition(World world, Entity entity, boolean includeLiquids, double reach) {
        if (entity == null || world == null || reach < 1.0) {
            return null;
        }
        Vec3d vecStart = new Vec3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_());
        Vec3d vecLook = entity.func_70676_i(1.0f);
        Vec3d vecEnd = vecStart.func_72441_c(vecLook.field_72450_a * reach, vecLook.field_72448_b * reach, vecLook.field_72449_c * reach);
        return world.func_217299_a(new RayTraceContext(vecStart, vecEnd, RayTraceContext.BlockMode.OUTLINE, includeLiquids ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE, entity));
    }

    public static class BlockInfo {
        public final BlockPos pos;
        public final BlockState state;
        public final Block block;
        public final Direction face;
        public final int sub;
        public final Vec3d vec;

        public BlockInfo(World world, BlockRayTraceResult mop) {
            this.pos = mop.func_216350_a();
            this.state = world.func_180495_p(this.pos);
            this.block = this.state.func_177230_c();
            this.face = mop.func_216354_b();
            this.sub = mop.subHit;
            this.vec = mop.func_216347_e();
        }

        public String toString() {
            return "POS: " + this.pos + " -State: " + this.state + " -SideHit: " + this.face + " -SubHit: " + this.sub + " -HitVec: " + this.vec;
        }
    }
}

